/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.comparator.IntComparator;
import org.apache.directory.mavibot.btree.exception.SerializerCreationException;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;

public class IntSerializer
extends AbstractElementSerializer<Integer> {
    public static final IntSerializer INSTANCE = new IntSerializer();

    private IntSerializer() {
        super(IntComparator.INSTANCE);
    }

    public static Integer deserialize(byte[] in) {
        return IntSerializer.deserialize(in, 0);
    }

    public static Integer deserialize(byte[] in, int start) {
        if (in == null || in.length < 4 + start) {
            throw new SerializerCreationException("Cannot extract a Integer from a buffer with not enough bytes");
        }
        return (in[start] << 24) + ((in[start + 1] & 0xFF) << 16) + ((in[start + 2] & 0xFF) << 8) + (in[start + 3] & 0xFF);
    }

    @Override
    public Integer fromBytes(byte[] in) {
        return IntSerializer.deserialize(in, 0);
    }

    @Override
    public Integer fromBytes(byte[] in, int start) {
        if (in == null || in.length < 4 + start) {
            throw new SerializerCreationException("Cannot extract a Integer from a buffer with not enough bytes");
        }
        return (in[start] << 24) + ((in[start + 1] & 0xFF) << 16) + ((in[start + 2] & 0xFF) << 8) + (in[start + 3] & 0xFF);
    }

    @Override
    public Integer deserialize(ByteBuffer buffer) throws IOException {
        return buffer.getInt();
    }

    @Override
    public Integer deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(4);
        return IntSerializer.deserialize(in);
    }

    @Override
    public byte[] serialize(Integer element) {
        return IntSerializer.serialize(element);
    }

    public static byte[] serialize(int value) {
        byte[] bytes = new byte[4];
        return IntSerializer.serialize(bytes, 0, value);
    }

    public static byte[] serialize(byte[] buffer, int start, int value) {
        buffer[start] = (byte)(value >>> 24);
        buffer[start + 1] = (byte)(value >>> 16);
        buffer[start + 2] = (byte)(value >>> 8);
        buffer[start + 3] = (byte)value;
        return buffer;
    }
}

