/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.Map;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.config.client.PropertiesConstants;
import org.pac4j.core.credentials.password.SpringSecurityPasswordEncoder;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.password.StandardPasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;

public class SpringEncoderBuilder
extends AbstractBuilder {
    public SpringEncoderBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreatePasswordEncoder(Map<String, org.pac4j.core.credentials.password.PasswordEncoder> encoders) {
        for (int i = 0; i <= 10; ++i) {
            PasswordEncoder encoder;
            String type = this.getProperty("encoder.spring.type", i);
            if (!CommonHelper.isNotBlank((String)type)) continue;
            if (PropertiesConstants.SpringEncoderType.NOOP.toString().equalsIgnoreCase(type)) {
                encoder = NoOpPasswordEncoder.getInstance();
            } else if (PropertiesConstants.SpringEncoderType.BCRYPT.toString().equalsIgnoreCase(type)) {
                encoder = this.containsProperty("encoder.spring.bcrypt.length", i) ? new BCryptPasswordEncoder(this.getPropertyAsInteger("encoder.spring.bcrypt.length", i)) : new BCryptPasswordEncoder();
            } else if (PropertiesConstants.SpringEncoderType.PBKDF2.toString().equalsIgnoreCase(type)) {
                if (this.containsProperty("encoder.spring.pbkdf2.secret", i)) {
                    String secret = this.getProperty("encoder.spring.pbkdf2.secret", i);
                    encoder = this.containsProperty("encoder.spring.pbkdf2.iterations", i) && this.containsProperty("encoder.spring.pbkdf2.hashWidth", i) ? new Pbkdf2PasswordEncoder((CharSequence)secret, this.getPropertyAsInteger("encoder.spring.pbkdf2.iterations", i), this.getPropertyAsInteger("encoder.spring.pbkdf2.hashWidth", i)) : new Pbkdf2PasswordEncoder((CharSequence)secret);
                } else {
                    encoder = new Pbkdf2PasswordEncoder();
                }
            } else if (PropertiesConstants.SpringEncoderType.SCRYPT.toString().equalsIgnoreCase(type)) {
                encoder = this.containsProperty("encoder.spring.scrypt.cpuCost", i) && this.containsProperty("encoder.spring.scrypt.memoryCost", i) && this.containsProperty("encoder.spring.scrypt.parallelization", i) && this.containsProperty("encoder.spring.scrypt.keyLength", i) && this.containsProperty("encoder.spring.scrypt.saltLength", i) ? new SCryptPasswordEncoder(this.getPropertyAsInteger("encoder.spring.scrypt.cpuCost", i), this.getPropertyAsInteger("encoder.spring.scrypt.memoryCost", i), this.getPropertyAsInteger("encoder.spring.scrypt.parallelization", i), this.getPropertyAsInteger("encoder.spring.scrypt.keyLength", i), this.getPropertyAsInteger("encoder.spring.scrypt.saltLength", i)) : new SCryptPasswordEncoder();
            } else if (PropertiesConstants.SpringEncoderType.STANDARD.toString().equalsIgnoreCase(type)) {
                encoder = this.containsProperty("encoder.spring.standard.secret", i) ? new StandardPasswordEncoder((CharSequence)this.getProperty("encoder.spring.standard.secret", i)) : new StandardPasswordEncoder();
            } else {
                throw new TechnicalException("Unsupported spring encoder type: " + type);
            }
            encoders.put(this.concat("encoder.spring", i), (org.pac4j.core.credentials.password.PasswordEncoder)new SpringSecurityPasswordEncoder(encoder));
        }
    }
}

