/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.knox.gateway.shell.jdbc.JDBCUtils;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.shell.table.KnoxShellTableBuilder;

public class JDBCKnoxShellTableBuilder
extends KnoxShellTableBuilder {
    private String connectionUrl;
    private String driver;
    private Connection conn;
    private boolean tableManagedConnection = true;
    private String username;
    private String pass;

    public JDBCKnoxShellTableBuilder username(String username) {
        this.username = username;
        return this;
    }

    public JDBCKnoxShellTableBuilder password(String pass) {
        this.pass = pass;
        return this;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.pass;
    }

    JDBCKnoxShellTableBuilder(KnoxShellTable table) {
        super(table);
    }

    @Override
    public JDBCKnoxShellTableBuilder title(String title) {
        this.title = title;
        return this;
    }

    public JDBCKnoxShellTableBuilder connectTo(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public JDBCKnoxShellTableBuilder driver(String driver) throws Exception {
        this.driver = driver;
        this.loadDriver();
        return this;
    }

    private void loadDriver() throws Exception {
        try {
            Class.forName(this.driver).newInstance();
        }
        catch (ClassNotFoundException e) {
            System.out.println(String.format(Locale.US, "Unable to load the JDBC driver %s. Check your CLASSPATH.", this.driver));
            throw e;
        }
        catch (InstantiationException e) {
            System.out.println(String.format(Locale.US, "Unable to instantiate the JDBC driver %s", this.driver));
            throw e;
        }
        catch (IllegalAccessException e) {
            System.out.println(String.format(Locale.US, "Not allowed to access the JDBC driver %s", this.driver));
            throw e;
        }
    }

    public JDBCKnoxShellTableBuilder connection(Connection connection) {
        this.conn = connection;
        this.tableManagedConnection = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnoxShellTable sql(String sql) throws IOException, SQLException {
        this.conn = this.conn == null ? this.createConnection() : this.conn;
        try (Statement statement = this.conn.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            this.processResultSet(resultSet);
        }
        finally {
            if (this.conn != null && this.tableManagedConnection) {
                this.conn.close();
            }
        }
        return this.table;
    }

    private Connection createConnection() throws SQLException {
        return JDBCUtils.createConnection(this.connectionUrl, this.username, this.pass);
    }

    private void processResultSet(ResultSet resultSet) throws SQLException {
        int i;
        ResultSetMetaData metadata = resultSet.getMetaData();
        int colCount = metadata.getColumnCount();
        try {
            this.table.title(metadata.getTableName(1));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (i = 1; i < colCount + 1; ++i) {
            this.table.header(metadata.getColumnName(i));
        }
        while (resultSet.next()) {
            this.table.row();
            for (i = 1; i < colCount + 1; ++i) {
                try {
                    this.table.value(resultSet.getObject(metadata.getColumnName(i), Comparable.class));
                    continue;
                }
                catch (SQLException e) {
                    this.table.value((Comparable<? extends Object>)((Object)resultSet.getString(metadata.getColumnName(i))));
                }
            }
        }
    }

    public KnoxShellTable resultSet(ResultSet resultSet) throws SQLException {
        this.processResultSet(resultSet);
        return this.table;
    }
}

