/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.DecodingException;
import org.springframework.http.HttpMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.LoggingCodecSupport;
import org.springframework.http.codec.multipart.MultipartParser;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.codec.multipart.PartGenerator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class DefaultPartHttpMessageReader
extends LoggingCodecSupport
implements HttpMessageReader<Part> {
    private static final String IDENTIFIER = "spring-multipart";
    private int maxInMemorySize = 262144;
    private int maxHeadersSize = 8192;
    private long maxDiskUsagePerPart = -1L;
    private int maxParts = -1;
    private boolean streaming;
    private Scheduler blockingOperationScheduler = Schedulers.newBoundedElastic((int)Schedulers.DEFAULT_BOUNDED_ELASTIC_SIZE, (int)Schedulers.DEFAULT_BOUNDED_ELASTIC_QUEUESIZE, (String)"spring-multipart", (int)60, (boolean)true);
    private Mono<Path> fileStorageDirectory = Mono.defer(this::defaultFileStorageDirectory).cache();

    public void setMaxHeadersSize(int byteCount) {
        this.maxHeadersSize = byteCount;
    }

    public int getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.maxInMemorySize = maxInMemorySize;
    }

    public void setMaxDiskUsagePerPart(long maxDiskUsagePerPart) {
        this.maxDiskUsagePerPart = maxDiskUsagePerPart;
    }

    public void setMaxParts(int maxParts) {
        this.maxParts = maxParts;
    }

    public void setFileStorageDirectory(Path fileStorageDirectory) throws IOException {
        Assert.notNull((Object)fileStorageDirectory, (String)"FileStorageDirectory must not be null");
        if (!Files.exists(fileStorageDirectory, new LinkOption[0])) {
            Files.createDirectory(fileStorageDirectory, new FileAttribute[0]);
        }
        this.fileStorageDirectory = Mono.just((Object)fileStorageDirectory);
    }

    public void setBlockingOperationScheduler(Scheduler blockingOperationScheduler) {
        Assert.notNull((Object)blockingOperationScheduler, (String)"FileCreationScheduler must not be null");
        this.blockingOperationScheduler = blockingOperationScheduler;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.MULTIPART_FORM_DATA);
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        return Part.class.equals((Object)elementType.toClass()) && (mediaType == null || MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mediaType));
    }

    @Override
    public Mono<Part> readMono(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Mono.error((Throwable)new UnsupportedOperationException("Cannot read multipart request body into single Part"));
    }

    @Override
    public Flux<Part> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Flux.defer(() -> {
            byte[] boundary = DefaultPartHttpMessageReader.boundary(message);
            if (boundary == null) {
                return Flux.error((Throwable)new DecodingException("No multipart boundary found in Content-Type: \"" + message.getHeaders().getContentType() + "\""));
            }
            Flux<MultipartParser.Token> tokens = MultipartParser.parse(message.getBody(), boundary, this.maxHeadersSize);
            return PartGenerator.createParts(tokens, this.maxParts, this.maxInMemorySize, this.maxDiskUsagePerPart, this.streaming, this.fileStorageDirectory, this.blockingOperationScheduler);
        });
    }

    @Nullable
    private static byte[] boundary(HttpMessage message) {
        String boundary;
        MediaType contentType = message.getHeaders().getContentType();
        if (contentType != null && (boundary = contentType.getParameter("boundary")) != null) {
            return boundary.getBytes(StandardCharsets.ISO_8859_1);
        }
        return null;
    }

    private Mono<Path> defaultFileStorageDirectory() {
        return Mono.fromCallable(() -> {
            Path tempDirectory = Paths.get(System.getProperty("java.io.tmpdir"), IDENTIFIER);
            if (!Files.exists(tempDirectory, new LinkOption[0])) {
                Files.createDirectory(tempDirectory, new FileAttribute[0]);
            }
            return tempDirectory;
        }).subscribeOn(this.blockingOperationScheduler);
    }
}

