/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URIBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(URIBuilder.class);
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
    private String scheme;
    private String encodedSchemeSpecificPart;
    private String encodedAuthority;
    private String userInfo;
    private String encodedUserInfo;
    private String host;
    private int port;
    private String path;
    private String encodedPath;
    private String encodedQuery;
    private List<BasicNameValuePair> queryParams;
    private String query;
    private boolean encode;
    private String fragment;
    private String encodedFragment;

    public URIBuilder() {
        this.port = -1;
    }

    public URIBuilder(boolean encode) {
        this();
        this.setEncode(encode);
    }

    public URIBuilder(String string) {
        try {
            this.digestURI(new URI(string));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public URIBuilder(String string, boolean encode) {
        try {
            this.setEncode(encode);
            this.digestURI(new URI(string));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public URIBuilder(URI uri) {
        this.digestURI(uri);
    }

    private List<BasicNameValuePair> parseQuery(String query) {
        try {
            Charset utf8 = Charset.forName("UTF-8");
            if (query != null && !query.isEmpty()) {
                String[] parametersArray;
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (String parameter : parametersArray = query.split("&")) {
                    String[] parameterCombo = parameter.split("=");
                    if (parameterCombo.length < 1) continue;
                    String key = URLDecoder.decode(parameterCombo[0], utf8.name());
                    String val = parameterCombo.length == 2 ? URLDecoder.decode(parameterCombo[1], utf8.name()) : "";
                    list.add(new BasicNameValuePair(key, val));
                }
                return list;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<BasicNameValuePair>();
    }

    public URI build() {
        try {
            return new URI(this.buildString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isIPv6Address(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    private String buildString() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.encodedSchemeSpecificPart != null) {
            sb.append(this.encodedSchemeSpecificPart);
        } else {
            if (this.encodedAuthority != null) {
                sb.append("//").append(this.encodedAuthority);
            } else if (this.host != null) {
                sb.append("//");
                if (this.encodedUserInfo != null) {
                    sb.append(this.encodedUserInfo).append("@");
                } else if (this.userInfo != null) {
                    sb.append(this.encodeUserInfo(this.userInfo)).append("@");
                }
                if (URIBuilder.isIPv6Address(this.host)) {
                    sb.append("[").append(this.host).append("]");
                } else {
                    sb.append(this.host);
                }
                if (this.port >= 0) {
                    sb.append(":").append(this.port);
                }
            }
            if (this.encodedPath != null) {
                sb.append(URIBuilder.normalizePath(this.encodedPath));
            } else if (this.path != null) {
                sb.append(this.encodePath(URIBuilder.normalizePath(this.path)));
            }
            if (this.encodedQuery != null) {
                sb.append("?").append(this.encodedQuery);
            } else if (this.queryParams != null && !this.queryParams.isEmpty()) {
                sb.append("?").append(this.encodeUrlForm(this.queryParams));
            } else if (this.query != null) {
                sb.append("?").append(this.encodeUric(this.query));
            }
        }
        if (this.encodedFragment != null) {
            sb.append("#").append(this.encodedFragment);
        } else if (this.fragment != null) {
            sb.append("#").append(this.encodeUric(this.fragment));
        }
        return sb.toString();
    }

    public URIBuilder digestURI(URI uri) {
        this.scheme = uri.getScheme();
        this.encodedSchemeSpecificPart = uri.getRawSchemeSpecificPart();
        this.encodedAuthority = uri.getRawAuthority();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.encodedUserInfo = uri.getRawUserInfo();
        this.userInfo = uri.getUserInfo();
        this.encodedPath = uri.getRawPath();
        this.path = uri.getPath();
        this.encodedQuery = uri.getRawQuery();
        this.queryParams = this.parseQuery(uri.getRawQuery());
        this.encodedFragment = uri.getRawFragment();
        this.fragment = uri.getFragment();
        return this;
    }

    private String encodeUserInfo(String userInfo) {
        return this.encode ? CommonUtils.urlEncode(userInfo) : userInfo;
    }

    private String encodePath(String path) {
        return this.encode ? CommonUtils.urlEncode(path) : path;
    }

    private String encodeUrlForm(List<BasicNameValuePair> params) {
        StringBuilder result = new StringBuilder();
        for (BasicNameValuePair parameter : params) {
            String encodedValue;
            String encodedName = this.encode ? CommonUtils.urlEncode(parameter.getName()) : parameter.getName();
            String string = encodedValue = this.encode ? CommonUtils.urlEncode(parameter.getValue()) : parameter.getValue();
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    private String encodeUric(String fragment) {
        return this.encode ? CommonUtils.urlEncode(fragment) : fragment;
    }

    public URIBuilder setEncode(boolean encode) {
        this.encode = encode;
        return this;
    }

    public URIBuilder setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public URIBuilder setUserInfo(String userInfo) {
        this.userInfo = userInfo;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        this.encodedUserInfo = null;
        return this;
    }

    public URIBuilder setUserInfo(String username, String password) {
        return this.setUserInfo(username + ':' + password);
    }

    public URIBuilder setHost(String host) {
        this.host = host;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public URIBuilder setPort(int port) {
        this.port = port < 0 ? -1 : port;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public URIBuilder setPath(String path) {
        this.path = path;
        this.encodedSchemeSpecificPart = null;
        this.encodedPath = null;
        return this;
    }

    public URIBuilder setEncodedPath(String path) {
        this.encodedPath = path;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    public URIBuilder removeQuery() {
        this.queryParams = null;
        this.query = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    public URIBuilder setParameters(List<BasicNameValuePair> nvps) {
        this.queryParams = new ArrayList<BasicNameValuePair>();
        this.queryParams.addAll(nvps);
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder setParameters(String queryParameters) {
        this.queryParams = new ArrayList<BasicNameValuePair>();
        this.queryParams.addAll(this.parseQuery(queryParameters));
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder addParameters(List<BasicNameValuePair> nvps) {
        if (this.queryParams == null || this.queryParams.isEmpty()) {
            this.queryParams = new ArrayList<BasicNameValuePair>();
        }
        this.queryParams.addAll(nvps);
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder setParameters(BasicNameValuePair ... nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<BasicNameValuePair>();
        } else {
            this.queryParams.clear();
        }
        for (BasicNameValuePair nvp : nvps) {
            this.queryParams.add(nvp);
        }
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder addParameter(String param, String value) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<BasicNameValuePair>();
        }
        this.queryParams.add(new BasicNameValuePair(param, value));
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder setParameter(String param, String value) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<BasicNameValuePair>();
        }
        if (!this.queryParams.isEmpty()) {
            Iterator<BasicNameValuePair> it = this.queryParams.iterator();
            while (it.hasNext()) {
                BasicNameValuePair nvp = it.next();
                if (!nvp.getName().equals(param)) continue;
                it.remove();
            }
        }
        this.queryParams.add(new BasicNameValuePair(param, value));
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder clearParameters() {
        this.queryParams = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    public URIBuilder setCustomQuery(String query) {
        this.query = query;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.queryParams = null;
        return this;
    }

    public URIBuilder setFragment(String fragment) {
        this.fragment = fragment;
        this.encodedFragment = null;
        return this;
    }

    public URIBuilder setEncodedFragment(String fragment) {
        this.fragment = null;
        this.encodedFragment = fragment;
        return this;
    }

    public URIBuilder setEncodedQuery(String query) {
        this.query = null;
        this.encodedFragment = query;
        return this;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.path == null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public List<BasicNameValuePair> getQueryParams() {
        if (this.queryParams != null) {
            return new ArrayList<BasicNameValuePair>(this.queryParams);
        }
        return new ArrayList<BasicNameValuePair>();
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        return this.buildString();
    }

    private static String normalizePath(String path) {
        int n;
        String s = path;
        if (s == null) {
            return null;
        }
        for (n = 0; n < s.length() && s.charAt(n) == '/'; ++n) {
        }
        if (n > 1) {
            s = s.substring(n - 1);
        }
        return s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URIBuilder that = (URIBuilder)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.encode != that.encode) {
            return false;
        }
        if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) {
            return false;
        }
        if (this.encodedSchemeSpecificPart != null ? !this.encodedSchemeSpecificPart.equals(that.encodedSchemeSpecificPart) : that.encodedSchemeSpecificPart != null) {
            return false;
        }
        if (this.encodedAuthority != null ? !this.encodedAuthority.equals(that.encodedAuthority) : that.encodedAuthority != null) {
            return false;
        }
        if (this.userInfo != null ? !this.userInfo.equals(that.userInfo) : that.userInfo != null) {
            return false;
        }
        if (this.encodedUserInfo != null ? !this.encodedUserInfo.equals(that.encodedUserInfo) : that.encodedUserInfo != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.encodedPath != null ? !this.encodedPath.equals(that.encodedPath) : that.encodedPath != null) {
            return false;
        }
        if (this.encodedQuery != null ? !this.encodedQuery.equals(that.encodedQuery) : that.encodedQuery != null) {
            return false;
        }
        if (this.queryParams != null ? !this.queryParams.equals(that.queryParams) : that.queryParams != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        if (this.fragment != null ? !this.fragment.equals(that.fragment) : that.fragment != null) {
            return false;
        }
        return !(this.encodedFragment == null ? that.encodedFragment != null : !this.encodedFragment.equals(that.encodedFragment));
    }

    public int hashCode() {
        int result = this.scheme != null ? this.scheme.hashCode() : 0;
        result = 31 * result + (this.encodedSchemeSpecificPart != null ? this.encodedSchemeSpecificPart.hashCode() : 0);
        result = 31 * result + (this.encodedAuthority != null ? this.encodedAuthority.hashCode() : 0);
        result = 31 * result + (this.userInfo != null ? this.userInfo.hashCode() : 0);
        result = 31 * result + (this.encodedUserInfo != null ? this.encodedUserInfo.hashCode() : 0);
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.encodedPath != null ? this.encodedPath.hashCode() : 0);
        result = 31 * result + (this.encodedQuery != null ? this.encodedQuery.hashCode() : 0);
        result = 31 * result + (this.queryParams != null ? this.queryParams.hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        result = 31 * result + (this.encode ? 1 : 0);
        result = 31 * result + (this.fragment != null ? this.fragment.hashCode() : 0);
        result = 31 * result + (this.encodedFragment != null ? this.encodedFragment.hashCode() : 0);
        return result;
    }

    public static class BasicNameValuePair
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -6437800749411518984L;
        private final String name;
        private final String value;

        public BasicNameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            if (this.value == null) {
                return this.name;
            }
            int len = this.name.length() + 1 + this.value.length();
            StringBuilder buffer = new StringBuilder(len);
            buffer.append(this.name);
            buffer.append("=");
            buffer.append(this.value);
            return buffer.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object instanceof BasicNameValuePair) {
                BasicNameValuePair that = (BasicNameValuePair)object;
                return this.name.equals(that.name) && this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            return 133 * this.name.hashCode() * this.value.hashCode();
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

