/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiMetricList;
import com.cloudera.api.swagger.model.ApiNameservice;
import com.cloudera.api.swagger.model.ApiNameserviceList;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NameservicesResourceApi {
    private ApiClient apiClient;

    public NameservicesResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NameservicesResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getMetricsCall(String clusterName, String nameservice, String serviceName, String from, List<String> metrics, String to, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/nameservices/{nameservice}/metrics".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{nameservice\\}", this.apiClient.escapeString(nameservice.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        }
        if (metrics != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "metrics", metrics));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getMetricsValidateBeforeCall(String clusterName, String nameservice, String serviceName, String from, List<String> metrics, String to, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling getMetrics(Async)");
        }
        if (nameservice == null) {
            throw new ApiException("Missing the required parameter 'nameservice' when calling getMetrics(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling getMetrics(Async)");
        }
        Call call = this.getMetricsCall(clusterName, nameservice, serviceName, from, metrics, to, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiMetricList getMetrics(String clusterName, String nameservice, String serviceName, String from, List<String> metrics, String to, String view) throws ApiException {
        ApiResponse<ApiMetricList> resp = this.getMetricsWithHttpInfo(clusterName, nameservice, serviceName, from, metrics, to, view);
        return resp.getData();
    }

    public ApiResponse<ApiMetricList> getMetricsWithHttpInfo(String clusterName, String nameservice, String serviceName, String from, List<String> metrics, String to, String view) throws ApiException {
        Call call = this.getMetricsValidateBeforeCall(clusterName, nameservice, serviceName, from, metrics, to, view, null, null);
        Type localVarReturnType = new TypeToken<ApiMetricList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMetricsAsync(String clusterName, String nameservice, String serviceName, String from, List<String> metrics, String to, String view, final ApiCallback<ApiMetricList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMetricsValidateBeforeCall(clusterName, nameservice, serviceName, from, metrics, to, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiMetricList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listNameservicesCall(String clusterName, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/nameservices".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listNameservicesValidateBeforeCall(String clusterName, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling listNameservices(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling listNameservices(Async)");
        }
        Call call = this.listNameservicesCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiNameserviceList listNameservices(String clusterName, String serviceName, String view) throws ApiException {
        ApiResponse<ApiNameserviceList> resp = this.listNameservicesWithHttpInfo(clusterName, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiNameserviceList> listNameservicesWithHttpInfo(String clusterName, String serviceName, String view) throws ApiException {
        Call call = this.listNameservicesValidateBeforeCall(clusterName, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiNameserviceList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listNameservicesAsync(String clusterName, String serviceName, String view, final ApiCallback<ApiNameserviceList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listNameservicesValidateBeforeCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiNameserviceList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readNameserviceCall(String clusterName, String nameservice, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/nameservices/{nameservice}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{nameservice\\}", this.apiClient.escapeString(nameservice.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readNameserviceValidateBeforeCall(String clusterName, String nameservice, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readNameservice(Async)");
        }
        if (nameservice == null) {
            throw new ApiException("Missing the required parameter 'nameservice' when calling readNameservice(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readNameservice(Async)");
        }
        Call call = this.readNameserviceCall(clusterName, nameservice, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiNameservice readNameservice(String clusterName, String nameservice, String serviceName, String view) throws ApiException {
        ApiResponse<ApiNameservice> resp = this.readNameserviceWithHttpInfo(clusterName, nameservice, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiNameservice> readNameserviceWithHttpInfo(String clusterName, String nameservice, String serviceName, String view) throws ApiException {
        Call call = this.readNameserviceValidateBeforeCall(clusterName, nameservice, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiNameservice>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readNameserviceAsync(String clusterName, String nameservice, String serviceName, String view, final ApiCallback<ApiNameservice> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readNameserviceValidateBeforeCall(clusterName, nameservice, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiNameservice>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

