/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.redirect;

import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.util.CommonHelper;

public class RedirectAction {
    private RedirectType type;
    private String location;
    private String content;

    protected RedirectAction() {
    }

    public static RedirectAction redirect(String location) {
        RedirectAction action = new RedirectAction();
        action.type = RedirectType.REDIRECT;
        action.location = location;
        return action;
    }

    public static RedirectAction success(String content) {
        RedirectAction action = new RedirectAction();
        action.type = RedirectType.SUCCESS;
        action.content = content;
        return action;
    }

    public static RedirectAction post(String location, Map<String, String> data) {
        RedirectAction action = new RedirectAction();
        action.type = RedirectType.SUCCESS;
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>\n");
        buffer.append("<body>\n");
        buffer.append("<form action=\"" + RedirectAction.escapeHtml(location) + "\" name=\"f\" method=\"post\">\n");
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                buffer.append("<input type='hidden' name=\"" + RedirectAction.escapeHtml(entry.getKey()) + "\" value=\"" + entry.getValue() + "\" />\n");
            }
        }
        buffer.append("<input value='POST' type='submit' />\n");
        buffer.append("</form>\n");
        buffer.append("<script type='text/javascript'>document.forms['f'].submit();</script>\n");
        buffer.append("</body>\n");
        buffer.append("</html>\n");
        action.content = buffer.toString();
        return action;
    }

    protected static String escapeHtml(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;");
    }

    public HttpAction perform(WebContext context) {
        if (this.type == RedirectType.REDIRECT) {
            return HttpAction.redirect(context, this.location);
        }
        return HttpAction.ok(context, this.content);
    }

    public RedirectType getType() {
        return this.type;
    }

    public String getLocation() {
        return this.location;
    }

    public String getContent() {
        return this.content;
    }

    protected void setType(RedirectType type) {
        this.type = type;
    }

    protected void setLocation(String loc) {
        this.location = loc;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), new Object[]{"type", this.type, "location", this.location, "content", this.content});
    }

    public static enum RedirectType {
        REDIRECT,
        SUCCESS;

    }
}

