/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/cdk/a11y"),require("@angular/cdk/portal"),require("@angular/cdk/stepper"),require("@angular/common"),require("@angular/core"),require("@angular/material/button"),require("@angular/material/core"),require("@angular/material/icon"),require("@angular/cdk/coercion"),require("rxjs/Subject"),require("@angular/cdk/bidi"),require("rxjs/operators/takeUntil"),require("@angular/animations")):"function"==typeof define&&define.amd?define(["exports","@angular/cdk/a11y","@angular/cdk/portal","@angular/cdk/stepper","@angular/common","@angular/core","@angular/material/button","@angular/material/core","@angular/material/icon","@angular/cdk/coercion","rxjs/Subject","@angular/cdk/bidi","rxjs/operators/takeUntil","@angular/animations"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.stepper=e.ng.material.stepper||{}),e.ng.cdk.a11y,e.ng.cdk.portal,e.ng.cdk.stepper,e.ng.common,e.ng.core,e.ng.material.button,e.ng.material.core,e.ng.material.icon,e.ng.cdk.coercion,e.Rx,e.ng.cdk.bidi,e.Rx.operators,e.ng.animations)}(this,function(e,t,r,n,i,a,o,p,s,l,c,d,u,m){"use strict";function h(e,t){function r(){this.constructor=e}g(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}var g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])},f=function(e){function t(t){return e.call(this,t)||this}return h(t,e),t.decorators=[{type:a.Directive,args:[{selector:"[matStepLabel]"}]}],t.ctorParameters=function(){return[{type:a.TemplateRef}]},t}(n.CdkStepLabel),v=function(){function e(){this.changes=new c.Subject,this.optionalLabel="Optional"}return e.decorators=[{type:a.Injectable}],e.ctorParameters=function(){return[]},e}(),b=function(){function e(e,t,r,n){this._intl=e,this._focusMonitor=t,this._element=r,t.monitor(r.nativeElement,!0),this._intlSubscription=e.changes.subscribe(function(){return n.markForCheck()})}return Object.defineProperty(e.prototype,"index",{get:function(){return this._index},set:function(e){this._index=l.coerceNumberProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"selected",{get:function(){return this._selected},set:function(e){this._selected=l.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"active",{get:function(){return this._active},set:function(e){this._active=l.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"optional",{get:function(){return this._optional},set:function(e){this._optional=l.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),e.prototype.ngOnDestroy=function(){this._intlSubscription.unsubscribe(),this._focusMonitor.stopMonitoring(this._element.nativeElement)},e.prototype._stringLabel=function(){return this.label instanceof f?null:this.label},e.prototype._templateLabel=function(){return this.label instanceof f?this.label:null},e.prototype._getHostElement=function(){return this._element.nativeElement},e.decorators=[{type:a.Component,args:[{selector:"mat-step-header",template:'<div class="mat-step-header-ripple" mat-ripple [matRippleTrigger]="_getHostElement()"></div><div [class.mat-step-icon]="state !== \'number\' || selected" [class.mat-step-icon-not-touched]="state == \'number\' && !selected" [ngSwitch]="state"><span *ngSwitchCase="\'number\'">{{index + 1}}</span><ng-container *ngSwitchCase="\'edit\'" [ngSwitch]="!!(iconOverrides && iconOverrides.edit)"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides.edit"></ng-container><mat-icon *ngSwitchDefault>create</mat-icon></ng-container><ng-container *ngSwitchCase="\'done\'" [ngSwitch]="!!(iconOverrides && iconOverrides.done)"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides.done"></ng-container><mat-icon *ngSwitchDefault>done</mat-icon></ng-container></div><div class="mat-step-label" [class.mat-step-label-active]="active" [class.mat-step-label-selected]="selected"><ng-container *ngIf="_templateLabel()" [ngTemplateOutlet]="_templateLabel()!.template"></ng-container><div class="mat-step-text-label" *ngIf="_stringLabel()">{{label}}</div><div class="mat-step-optional" *ngIf="optional">{{_intl.optionalLabel}}</div></div>',styles:[".mat-step-header{overflow:hidden;outline:0;cursor:pointer;position:relative;box-sizing:content-box}.mat-step-optional{font-size:12px}.mat-step-icon,.mat-step-icon-not-touched{border-radius:50%;height:24px;width:24px;align-items:center;justify-content:center;display:flex}.mat-step-icon .mat-icon{font-size:16px;height:16px;width:16px}.mat-step-label{display:inline-block;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;min-width:50px;vertical-align:middle}.mat-step-text-label{text-overflow:ellipsis;overflow:hidden}.mat-step-header-ripple{top:0;left:0;right:0;bottom:0;position:absolute;pointer-events:none}"],host:{class:"mat-step-header",role:"tab"},encapsulation:a.ViewEncapsulation.None,preserveWhitespaces:!1,changeDetection:a.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:v},{type:t.FocusMonitor},{type:a.ElementRef},{type:a.ChangeDetectorRef}]},e.propDecorators={state:[{type:a.Input}],label:[{type:a.Input}],iconOverrides:[{type:a.Input}],index:[{type:a.Input}],selected:[{type:a.Input}],active:[{type:a.Input}],optional:[{type:a.Input}]},e}(),x={horizontalStepTransition:m.trigger("stepTransition",[m.state("previous",m.style({transform:"translate3d(-100%, 0, 0)",visibility:"hidden"})),m.state("current",m.style({transform:"none",visibility:"visible"})),m.state("next",m.style({transform:"translate3d(100%, 0, 0)",visibility:"hidden"})),m.transition("* => *",m.animate("500ms cubic-bezier(0.35, 0, 0.25, 1)"))]),verticalStepTransition:m.trigger("stepTransition",[m.state("previous",m.style({height:"0px",visibility:"hidden"})),m.state("next",m.style({height:"0px",visibility:"hidden"})),m.state("current",m.style({height:"*",visibility:"visible"})),m.transition("* <=> current",m.animate("225ms cubic-bezier(0.4, 0.0, 0.2, 1)"))])},y=function(){function e(e){this.templateRef=e}return e.decorators=[{type:a.Directive,args:[{selector:"ng-template[matStepperIcon]"}]}],e.ctorParameters=function(){return[{type:a.TemplateRef}]},e.propDecorators={name:[{type:a.Input,args:["matStepperIcon"]}]},e}(),S=n.CdkStep,_=n.CdkStepper,w=function(e){function t(t,r){var n=e.call(this,t)||this;return n._errorStateMatcher=r,n}return h(t,e),t.prototype.isErrorState=function(e,t){var r=this._errorStateMatcher.isErrorState(e,t),n=!!(e&&e.invalid&&this.interacted);return r||n},t.decorators=[{type:a.Component,args:[{selector:"mat-step",template:"<ng-template><ng-content></ng-content></ng-template>",providers:[{provide:p.ErrorStateMatcher,useExisting:t}],encapsulation:a.ViewEncapsulation.None,exportAs:"matStep",preserveWhitespaces:!1,changeDetection:a.ChangeDetectionStrategy.OnPush}]}],t.ctorParameters=function(){return[{type:I,decorators:[{type:a.Inject,args:[a.forwardRef(function(){return I})]}]},{type:p.ErrorStateMatcher,decorators:[{type:a.SkipSelf}]}]},t.propDecorators={stepLabel:[{type:a.ContentChild,args:[f]}]},t}(n.CdkStep),I=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._iconOverrides={},t}return h(t,e),t.prototype.ngAfterContentInit=function(){var e=this,t=this._icons.toArray(),r=t.find(function(e){return"edit"===e.name}),n=t.find(function(e){return"done"===e.name});r&&(this._iconOverrides.edit=r.templateRef),n&&(this._iconOverrides.done=n.templateRef),this._steps.changes.pipe(u.takeUntil(this._destroyed)).subscribe(function(){return e._stateChanged()})},t.decorators=[{type:a.Directive,args:[{selector:"[matStepper]"}]}],t.ctorParameters=function(){return[]},t.propDecorators={_stepHeader:[{type:a.ViewChildren,args:[b,{read:a.ElementRef}]}],_steps:[{type:a.ContentChildren,args:[w]}],_icons:[{type:a.ContentChildren,args:[y]}]},t}(n.CdkStepper),C=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return h(t,e),t.decorators=[{type:a.Component,args:[{selector:"mat-horizontal-stepper",exportAs:"matHorizontalStepper",template:'<div class="mat-horizontal-stepper-header-container"><ng-container *ngFor="let step of _steps; let i = index; let isLast = last"><mat-step-header class="mat-horizontal-stepper-header" (click)="step.select()" (keydown)="_onKeydown($event)" [tabIndex]="_focusIndex === i ? 0 : -1" [id]="_getStepLabelId(i)" [attr.aria-controls]="_getStepContentId(i)" [attr.aria-selected]="selectedIndex == i" [index]="i" [state]="_getIndicatorType(i)" [label]="step.stepLabel || step.label" [selected]="selectedIndex === i" [active]="step.completed || selectedIndex === i || !linear" [optional]="step.optional" [iconOverrides]="_iconOverrides"></mat-step-header><div *ngIf="!isLast" class="mat-stepper-horizontal-line"></div></ng-container></div><div class="mat-horizontal-content-container"><div *ngFor="let step of _steps; let i = index" class="mat-horizontal-stepper-content" role="tabpanel" [@stepTransition]="_getAnimationDirection(i)" [id]="_getStepContentId(i)" [attr.aria-labelledby]="_getStepLabelId(i)" [attr.aria-expanded]="selectedIndex === i"><ng-container [ngTemplateOutlet]="step.content"></ng-container></div></div>',styles:[".mat-stepper-horizontal,.mat-stepper-vertical{display:block}.mat-horizontal-stepper-header-container{white-space:nowrap;display:flex;align-items:center}.mat-stepper-horizontal-line{border-top-width:1px;border-top-style:solid;flex:auto;height:0;margin:0 -16px;min-width:32px}.mat-horizontal-stepper-header{display:flex;height:72px;overflow:hidden;align-items:center;padding:0 24px}.mat-horizontal-stepper-header .mat-step-icon,.mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:8px;flex:none}[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon,[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:8px}.mat-vertical-stepper-header{display:flex;align-items:center;padding:24px;max-height:24px}.mat-vertical-stepper-header .mat-step-icon,.mat-vertical-stepper-header .mat-step-icon-not-touched{margin-right:12px}[dir=rtl] .mat-vertical-stepper-header .mat-step-icon,[dir=rtl] .mat-vertical-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:12px}.mat-horizontal-stepper-content{overflow:hidden}.mat-horizontal-stepper-content[aria-expanded=false]{height:0}.mat-horizontal-content-container{overflow:hidden;padding:0 24px 24px 24px}.mat-vertical-content-container{margin-left:36px;border:0;position:relative}[dir=rtl] .mat-vertical-content-container{margin-left:0;margin-right:36px}.mat-stepper-vertical-line::before{content:'';position:absolute;top:-16px;bottom:-16px;left:0;border-left-width:1px;border-left-style:solid}[dir=rtl] .mat-stepper-vertical-line::before{left:auto;right:0}.mat-vertical-stepper-content{overflow:hidden}.mat-vertical-content{padding:0 24px 24px 24px}.mat-step:last-child .mat-vertical-content-container{border:none}"],inputs:["selectedIndex"],host:{class:"mat-stepper-horizontal","aria-orientation":"horizontal",role:"tablist"},animations:[x.horizontalStepTransition],providers:[{provide:I,useExisting:t}],encapsulation:a.ViewEncapsulation.None,preserveWhitespaces:!1,changeDetection:a.ChangeDetectionStrategy.OnPush}]}],t.ctorParameters=function(){return[]},t}(I),k=function(e){function t(t,r){var n=e.call(this,t,r)||this;return n._orientation="vertical",n}return h(t,e),t.decorators=[{type:a.Component,args:[{selector:"mat-vertical-stepper",exportAs:"matVerticalStepper",template:'<div class="mat-step" *ngFor="let step of _steps; let i = index; let isLast = last"><mat-step-header class="mat-vertical-stepper-header" (click)="step.select()" (keydown)="_onKeydown($event)" [tabIndex]="_focusIndex == i ? 0 : -1" [id]="_getStepLabelId(i)" [attr.aria-controls]="_getStepContentId(i)" [attr.aria-selected]="selectedIndex === i" [index]="i" [state]="_getIndicatorType(i)" [label]="step.stepLabel || step.label" [selected]="selectedIndex === i" [active]="step.completed || selectedIndex === i || !linear" [optional]="step.optional" [iconOverrides]="_iconOverrides"></mat-step-header><div class="mat-vertical-content-container" [class.mat-stepper-vertical-line]="!isLast"><div class="mat-vertical-stepper-content" role="tabpanel" [@stepTransition]="_getAnimationDirection(i)" [id]="_getStepContentId(i)" [attr.aria-labelledby]="_getStepLabelId(i)" [attr.aria-expanded]="selectedIndex === i"><div class="mat-vertical-content"><ng-container [ngTemplateOutlet]="step.content"></ng-container></div></div></div></div>',styles:[".mat-stepper-horizontal,.mat-stepper-vertical{display:block}.mat-horizontal-stepper-header-container{white-space:nowrap;display:flex;align-items:center}.mat-stepper-horizontal-line{border-top-width:1px;border-top-style:solid;flex:auto;height:0;margin:0 -16px;min-width:32px}.mat-horizontal-stepper-header{display:flex;height:72px;overflow:hidden;align-items:center;padding:0 24px}.mat-horizontal-stepper-header .mat-step-icon,.mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:8px;flex:none}[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon,[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:8px}.mat-vertical-stepper-header{display:flex;align-items:center;padding:24px;max-height:24px}.mat-vertical-stepper-header .mat-step-icon,.mat-vertical-stepper-header .mat-step-icon-not-touched{margin-right:12px}[dir=rtl] .mat-vertical-stepper-header .mat-step-icon,[dir=rtl] .mat-vertical-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:12px}.mat-horizontal-stepper-content{overflow:hidden}.mat-horizontal-stepper-content[aria-expanded=false]{height:0}.mat-horizontal-content-container{overflow:hidden;padding:0 24px 24px 24px}.mat-vertical-content-container{margin-left:36px;border:0;position:relative}[dir=rtl] .mat-vertical-content-container{margin-left:0;margin-right:36px}.mat-stepper-vertical-line::before{content:'';position:absolute;top:-16px;bottom:-16px;left:0;border-left-width:1px;border-left-style:solid}[dir=rtl] .mat-stepper-vertical-line::before{left:auto;right:0}.mat-vertical-stepper-content{overflow:hidden}.mat-vertical-content{padding:0 24px 24px 24px}.mat-step:last-child .mat-vertical-content-container{border:none}"],inputs:["selectedIndex"],host:{class:"mat-stepper-vertical","aria-orientation":"vertical",role:"tablist"},animations:[x.verticalStepTransition],providers:[{provide:I,useExisting:t}],encapsulation:a.ViewEncapsulation.None,preserveWhitespaces:!1,changeDetection:a.ChangeDetectionStrategy.OnPush}]}],t.ctorParameters=function(){return[{type:d.Directionality,decorators:[{type:a.Optional}]},{type:a.ChangeDetectorRef}]},t}(I),z=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return h(t,e),t.decorators=[{type:a.Directive,args:[{selector:"button[matStepperNext]",host:{"(click)":"_stepper.next()","[type]":"type"},inputs:["type"],providers:[{provide:n.CdkStepper,useExisting:I}]}]}],t.ctorParameters=function(){return[]},t}(n.CdkStepperNext),M=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return h(t,e),t.decorators=[{type:a.Directive,args:[{selector:"button[matStepperPrevious]",host:{"(click)":"_stepper.previous()","[type]":"type"},inputs:["type"],providers:[{provide:n.CdkStepper,useExisting:I}]}]}],t.ctorParameters=function(){return[]},t}(n.CdkStepperPrevious),O=function(){function e(){}return e.decorators=[{type:a.NgModule,args:[{imports:[p.MatCommonModule,i.CommonModule,r.PortalModule,o.MatButtonModule,n.CdkStepperModule,s.MatIconModule,t.A11yModule,p.MatRippleModule],exports:[p.MatCommonModule,C,k,w,f,I,z,M,b,y],declarations:[C,k,w,f,I,z,M,b,y],providers:[v,p.ErrorStateMatcher]}]}],e.ctorParameters=function(){return[]},e}();e.MatStepperModule=O,e.MatStepLabel=f,e._MatStep=S,e._MatStepper=_,e.MatStep=w,e.MatStepper=I,e.MatHorizontalStepper=C,e.MatVerticalStepper=k,e.MatStepperNext=z,e.MatStepperPrevious=M,e.MatStepHeader=b,e.MatStepperIntl=v,e.matStepperAnimations=x,e.MatStepperIcon=y,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-stepper.umd.min.js.map
