/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.reader;

import java.io.IOException;
import net.minidev.asm.Accessor;
import net.minidev.asm.BeansAccess;
import net.minidev.asm.FieldFilter;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONUtil;
import net.minidev.json.reader.JsonWriterI;

public class BeansWriterASM
implements JsonWriterI<Object> {
    @Override
    public <E> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
        Class<?> cls = value.getClass();
        boolean needSep = false;
        BeansAccess fields = BeansAccess.get(cls, (FieldFilter)JSONUtil.JSON_SMART_FIELD_FILTER);
        out.append('{');
        Accessor[] accessorArray = fields.getAccessors();
        int n = accessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Accessor field = accessorArray[n2];
            Object v = fields.get(value, field.getIndex());
            if (v != null || !compression.ignoreNull()) {
                if (needSep) {
                    out.append(',');
                } else {
                    needSep = true;
                }
                String key = field.getName();
                JSONObject.writeJSONKV(key, v, out, compression);
            }
            ++n2;
        }
        out.append('}');
    }
}

