/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.config;

import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.oauth.OAuthService;
import java.util.function.Function;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;

public class OAuthConfiguration<S extends OAuthService, T extends Token>
extends InitializableObject {
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String RESPONSE_TYPE_CODE = "code";
    private String key;
    private String secret;
    private boolean tokenAsHeader;
    private String responseType = "code";
    private String scope;
    private BaseApi<S> api;
    private Function<WebContext, Boolean> hasBeenCancelledFactory = ctx -> false;
    private OAuthProfileDefinition profileDefinition;
    private HttpClientConfig httpClientConfig;

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"key", (String)this.key);
        CommonHelper.assertNotBlank((String)"secret", (String)this.secret);
        CommonHelper.assertNotNull((String)"api", this.api);
        CommonHelper.assertNotNull((String)"hasBeenCancelledFactory", this.hasBeenCancelledFactory);
        CommonHelper.assertNotNull((String)"profileDefinition", (Object)((Object)this.profileDefinition));
    }

    public S buildService(WebContext context, IndirectClient client, String state) {
        this.init();
        String finalCallbackUrl = client.computeFinalCallbackUrl(context);
        return (S)this.getApi().createService(this.key, this.secret, finalCallbackUrl, this.scope, null, state, this.responseType, null, this.httpClientConfig, null);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean isTokenAsHeader() {
        return this.tokenAsHeader;
    }

    public void setTokenAsHeader(boolean tokenAsHeader) {
        this.tokenAsHeader = tokenAsHeader;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public BaseApi<S> getApi() {
        return this.api;
    }

    public void setApi(BaseApi<S> api) {
        this.api = api;
    }

    public Function<WebContext, Boolean> getHasBeenCancelledFactory() {
        return this.hasBeenCancelledFactory;
    }

    public void setHasBeenCancelledFactory(Function<WebContext, Boolean> hasBeenCancelledFactory) {
        this.hasBeenCancelledFactory = hasBeenCancelledFactory;
    }

    public OAuthProfileDefinition getProfileDefinition() {
        return this.profileDefinition;
    }

    public void setProfileDefinition(OAuthProfileDefinition profileDefinition) {
        this.profileDefinition = profileDefinition;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"key", this.key, "secret", "[protected]", "tokenAsHeader", this.tokenAsHeader, "responseType", this.responseType, "scope", this.scope, "api", this.api, "hasBeenCancelledFactory", this.hasBeenCancelledFactory, "profileDefinition", this.profileDefinition, "httpClientConfig", this.httpClientConfig});
    }
}

