/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.svcregfunc.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.svcregfunc.api.ServiceUrlFunctionDescriptor;
import org.apache.knox.gateway.svcregfunc.impl.ServiceRegistryFunctionProcessorBase;

public class ServiceUrlFunctionProcessor
extends ServiceRegistryFunctionProcessorBase<ServiceUrlFunctionDescriptor>
implements UrlRewriteFunctionProcessor<ServiceUrlFunctionDescriptor> {
    public String name() {
        return "serviceUrl";
    }

    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        ArrayList<String> results = null;
        if (parameters != null) {
            UrlRewriter.Direction direction = context.getDirection();
            results = new ArrayList<String>(parameters.size());
            for (String parameter : parameters) {
                parameter = this.resolve(parameter);
                results.add(parameter);
            }
        }
        return results;
    }

    private String resolve(String parameter) throws Exception {
        String url = this.lookupServiceUrl(parameter);
        if (url != null) {
            URI inputUri = new URI(url);
            String host = inputUri.getHost();
            URI outputUri = new URI(inputUri.getScheme(), inputUri.getUserInfo(), host, inputUri.getPort(), inputUri.getPath(), inputUri.getQuery(), inputUri.getFragment());
            parameter = outputUri.toString();
        }
        return parameter;
    }
}

