/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.evaluator.AndEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.ApproximateEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.EmptyEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.EqualityEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.GreaterEqEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.LessEqEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.NotEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.OneLevelScopeEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.OrEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.PresenceEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.SubstringEvaluator;
import org.apache.directory.server.xdbm.search.evaluator.SubtreeScopeEvaluator;

public class EvaluatorBuilder {
    private final Store db;
    private final SchemaManager schemaManager;
    private static final EmptyEvaluator EMPTY_EVALLUATOR = new EmptyEvaluator();

    public EvaluatorBuilder(Store db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.schemaManager = schemaManager;
    }

    public <T> Evaluator<? extends ExprNode> build(ExprNode node) throws Exception {
        Object count = node.get("count");
        if (count != null && (Long)count == 0L) {
            return EMPTY_EVALLUATOR;
        }
        switch (node.getAssertionType()) {
            case APPROXIMATE: {
                return new ApproximateEvaluator((ApproximateNode)node, this.db, this.schemaManager);
            }
            case EQUALITY: {
                return new EqualityEvaluator((EqualityNode)node, this.db, this.schemaManager);
            }
            case GREATEREQ: {
                return new GreaterEqEvaluator((GreaterEqNode)node, this.db, this.schemaManager);
            }
            case LESSEQ: {
                return new LessEqEvaluator((LessEqNode)node, this.db, this.schemaManager);
            }
            case PRESENCE: {
                return new PresenceEvaluator((PresenceNode)node, this.db, this.schemaManager);
            }
            case SCOPE: {
                if (((ScopeNode)node).getScope() == SearchScope.ONELEVEL) {
                    return new OneLevelScopeEvaluator(this.db, (ScopeNode)node);
                }
                return new SubtreeScopeEvaluator(this.db, (ScopeNode)node);
            }
            case SUBSTRING: {
                return new SubstringEvaluator((SubstringNode)node, this.db, this.schemaManager);
            }
            case AND: {
                return this.buildAndEvaluator((AndNode)node);
            }
            case NOT: {
                return new NotEvaluator((NotNode)node, this.build(((NotNode)node).getFirstChild()));
            }
            case OR: {
                return this.buildOrEvaluator((OrNode)node);
            }
            case ASSERTION: 
            case EXTENSIBLE: {
                throw new NotImplementedException();
            }
        }
        throw new IllegalStateException(I18n.err(I18n.ERR_260, new Object[]{node.getAssertionType()}));
    }

    private <T> Evaluator<? extends ExprNode> buildAndEvaluator(AndNode node) throws Exception {
        List<ExprNode> children = node.getChildren();
        List<Evaluator<? extends ExprNode>> evaluators = this.buildList(children);
        int size = evaluators.size();
        switch (size) {
            case 0: {
                return EMPTY_EVALLUATOR;
            }
            case 1: {
                return evaluators.get(0);
            }
        }
        return new AndEvaluator(node, evaluators);
    }

    private <T> Evaluator<? extends ExprNode> buildOrEvaluator(OrNode node) throws Exception {
        List<ExprNode> children = node.getChildren();
        List<Evaluator<? extends ExprNode>> evaluators = this.buildList(children);
        int size = evaluators.size();
        switch (size) {
            case 0: {
                return EMPTY_EVALLUATOR;
            }
            case 1: {
                return evaluators.get(0);
            }
        }
        return new OrEvaluator(node, evaluators);
    }

    private List<Evaluator<? extends ExprNode>> buildList(List<ExprNode> children) throws Exception {
        ArrayList<Evaluator<? extends ExprNode>> evaluators = new ArrayList<Evaluator<? extends ExprNode>>(children.size());
        for (ExprNode child : children) {
            Evaluator<ExprNode> evaluator = this.build(child);
            if (evaluator == null) continue;
            evaluators.add(evaluator);
        }
        return evaluators;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }
}

