/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.extendedRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedRequestValue
extends GrammarAction<LdapMessageContainer<ExtendedRequestDecorator<?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedRequestValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreExtendedRequestValue() {
        super("Store ExtendedRequest value");
    }

    @Override
    public void action(LdapMessageContainer<ExtendedRequestDecorator<?>> container) throws DecoderException {
        ExtendedRequestDecorator<?> extendedRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            extendedRequest.setRequestValue(Strings.EMPTY_BYTES);
        } else {
            extendedRequest.setRequestValue(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Extended value : {}", (Object)extendedRequest.getRequestValue());
        }
    }
}

