/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.filter.AbstractGatewayFilter;

public class RedirectToUrlFilter
extends AbstractGatewayFilter {
    public static final String REDIRECT_TO_URL = "redirectToUrl";
    protected String redirectUrl = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.redirectUrl = filterConfig.getInitParameter(REDIRECT_TO_URL);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.redirectUrl != null && request.getHeader("Authorization") == null) {
            response.sendRedirect(this.redirectUrl + this.getOriginalQueryString(request));
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getOriginalQueryString(HttpServletRequest request) {
        String originalQueryString = request.getQueryString();
        return originalQueryString == null ? "" : "?" + originalQueryString;
    }
}

