/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.karaf.management.JMXSecurityMBean;
import org.apache.karaf.management.KarafMBeanServerGuard;
import org.apache.karaf.management.internal.BulkRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXSecurityMBeanImpl
extends StandardMBean
implements JMXSecurityMBean {
    private static final Logger LOG = LoggerFactory.getLogger(JMXSecurityMBeanImpl.class);
    private MBeanServer mbeanServer;
    private KarafMBeanServerGuard guard;

    public JMXSecurityMBeanImpl() throws NotCompliantMBeanException {
        super(JMXSecurityMBean.class);
    }

    @Override
    public boolean canInvoke(String objectName) throws Exception {
        return this.canInvoke((BulkRequestContext)null, objectName);
    }

    @Override
    public boolean canInvoke(String objectName, String methodName) throws Exception {
        return this.canInvoke(null, objectName, methodName);
    }

    @Override
    public boolean canInvoke(String objectName, String methodName, String[] argumentTypes) throws Exception {
        return this.canInvoke(null, objectName, methodName, argumentTypes);
    }

    private boolean canInvoke(BulkRequestContext context, String objectName) throws Exception {
        if (this.guard == null) {
            return true;
        }
        return this.guard.canInvoke(context, this.mbeanServer, new ObjectName(objectName));
    }

    private boolean canInvoke(BulkRequestContext context, String objectName, String methodName) throws Exception {
        if (this.guard == null) {
            return true;
        }
        return this.guard.canInvoke(context, this.mbeanServer, new ObjectName(objectName), methodName);
    }

    private boolean canInvoke(BulkRequestContext context, String objectName, String methodName, String[] argumentTypes) throws Exception {
        ObjectName on = new ObjectName(objectName);
        if (this.guard == null) {
            return true;
        }
        return this.guard.canInvoke(context, this.mbeanServer, on, methodName, argumentTypes);
    }

    @Override
    public TabularData canInvoke(Map<String, List<String>> bulkQuery) throws Exception {
        TabularDataSupport table = new TabularDataSupport(CAN_INVOKE_TABULAR_TYPE);
        BulkRequestContext context = BulkRequestContext.newContext(this.guard.getConfigAdmin());
        for (Map.Entry<String, List<String>> entry : bulkQuery.entrySet()) {
            String objectName = entry.getKey();
            List<String> methods = entry.getValue();
            if (methods.size() == 0) {
                boolean res = this.canInvoke(context, objectName);
                CompositeDataSupport data = new CompositeDataSupport(CAN_INVOKE_RESULT_ROW_TYPE, CAN_INVOKE_RESULT_COLUMNS, new Object[]{objectName, "", res});
                table.put(data);
                continue;
            }
            for (String method : methods) {
                ArrayList<String> argTypes;
                String name = this.parseMethodName(method, argTypes = new ArrayList<String>());
                boolean res = name.equals(method) ? this.canInvoke(context, objectName, name) : this.canInvoke(context, objectName, name, argTypes.toArray(new String[0]));
                CompositeDataSupport data = new CompositeDataSupport(CAN_INVOKE_RESULT_ROW_TYPE, CAN_INVOKE_RESULT_COLUMNS, new Object[]{objectName, method, res});
                try {
                    table.put(data);
                }
                catch (KeyAlreadyExistsException e) {
                    LOG.warn("{} (objectName = \"{}\", method = \"{}\")", new Object[]{e, objectName, method});
                }
            }
        }
        return table;
    }

    private String parseMethodName(String method, List<String> argTypes) {
        int index = (method = method.trim()).indexOf(40);
        if (index < 0) {
            return method;
        }
        String args = method.substring(index + 1, method.length() - 1);
        for (String arg : args.split(",")) {
            argTypes.add(arg);
        }
        return method.substring(0, index);
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public KarafMBeanServerGuard getGuard() {
        return this.guard;
    }

    public void setGuard(KarafMBeanServerGuard guard) {
        this.guard = guard;
    }
}

