/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.karaf.log.core.Level;
import org.apache.karaf.log.core.LogService;
import org.apache.karaf.log.core.internal.LruList;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class LogServiceImpl
implements LogService {
    static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String ALL_LOGGER = "ALL";
    static final String ROOT_LOGGER = "ROOT";
    private final ConfigurationAdmin configAdmin;
    private final LruList events;

    public LogServiceImpl(ConfigurationAdmin configAdmin, LruList events) {
        this.configAdmin = configAdmin;
        this.events = events;
    }

    @Override
    public String getLevel() {
        return this.getLevel(null).get(ROOT_LOGGER);
    }

    @Override
    public Map<String, String> getLevel(String logger) {
        String val;
        Configuration cfg;
        try {
            cfg = this.configAdmin.getConfiguration(CONFIGURATION_PID, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving Log information from config admin", e);
        }
        Dictionary props = cfg.getProperties();
        if (ROOT_LOGGER.equalsIgnoreCase(logger)) {
            logger = null;
        }
        TreeMap<String, String> loggers = new TreeMap<String, String>();
        if (ALL_LOGGER.equalsIgnoreCase(logger)) {
            String root = this.getLevelFromProperty((String)props.get(ROOT_LOGGER_PREFIX));
            loggers.put(ROOT_LOGGER, root);
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                if (!prop.startsWith(LOGGER_PREFIX)) continue;
                String val2 = this.getLevelFromProperty((String)props.get(prop));
                loggers.put(prop.substring(LOGGER_PREFIX.length()), val2);
            }
            return loggers;
        }
        String l = logger;
        while (true) {
            String prop = l == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + l;
            val = (String)props.get(prop);
            if ((val = this.getLevelFromProperty(val)) != null || l == null) break;
            int idx = l.lastIndexOf(46);
            if (idx < 0) {
                l = null;
                continue;
            }
            l = l.substring(0, idx);
        }
        if (logger == null) {
            logger = ROOT_LOGGER;
        }
        loggers.put(logger, val);
        return loggers;
    }

    @Override
    public void setLevel(String level) {
        this.setLevel(null, level);
    }

    @Override
    public void setLevel(String logger, String level) {
        int idx;
        if (ROOT_LOGGER.equalsIgnoreCase(logger)) {
            logger = null;
        }
        level = level.toUpperCase();
        Level.valueOf(level);
        if (Level.isDefault(level) && logger == null) {
            throw new IllegalStateException("Can not unset the ROOT logger");
        }
        Configuration cfg = this.getConfiguration();
        Dictionary props = cfg.getProperties();
        String prop = logger == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + logger;
        String val = (String)props.get(prop);
        if (Level.isDefault(level)) {
            if (val != null) {
                idx = (val = val.trim()).indexOf(",");
                val = idx < 0 ? null : val.substring(idx);
            }
        } else {
            val = val == null ? level : ((idx = (val = val.trim()).indexOf(",")) < 0 ? level : level + val.substring(idx));
        }
        if (val == null) {
            props.remove(prop);
        } else {
            props.put(prop, val);
        }
        try {
            cfg.update(props);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing log config to config admin", e);
        }
    }

    private boolean checkIfFromRequestedLog(PaxLoggingEvent event, String logger) {
        return event.getLoggerName().lastIndexOf(logger) >= 0;
    }

    private String getLevelFromProperty(String prop) {
        if (prop == null) {
            return null;
        }
        String val = prop.trim();
        int idx = val.indexOf(",");
        if (idx == 0) {
            val = null;
        } else if (idx > 0) {
            val = val.substring(0, idx);
        }
        return val;
    }

    private Configuration getConfiguration() {
        try {
            return this.configAdmin.getConfiguration(CONFIGURATION_PID, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving Log information from config admin", e);
        }
    }

    @Override
    public Iterable<PaxLoggingEvent> getEvents() {
        return this.events.getElements();
    }

    @Override
    public Iterable<PaxLoggingEvent> getEvents(int maxNum) {
        return this.events.getElements(maxNum);
    }

    @Override
    public void clearEvents() {
        this.events.clear();
    }

    @Override
    public PaxLoggingEvent getLastException(String logger) {
        PaxLoggingEvent throwableEvent = null;
        Iterable<PaxLoggingEvent> le = this.getEvents();
        for (PaxLoggingEvent event : le) {
            if (event.getThrowableStrRep() != null && logger != null && this.checkIfFromRequestedLog(event, logger)) {
                throwableEvent = event;
                continue;
            }
            if (event.getThrowableStrRep() == null || logger != null) continue;
            throwableEvent = event;
        }
        return throwableEvent;
    }

    @Override
    public void addAppender(PaxAppender appender) {
        this.events.addAppender(appender);
    }

    @Override
    public void removeAppender(PaxAppender appender) {
        this.events.removeAppender(appender);
    }

    public Level convertToLevel(String level) {
        Level res = Level.valueOf(level = level.toUpperCase());
        if (res == null) {
            throw new IllegalArgumentException("level must be set to TRACE, DEBUG, INFO, WARN or ERROR (or DEFAULT to unset it)");
        }
        return res;
    }
}

