/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.completers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;

public class StringsCompleter
implements Completer {
    private final SortedSet<String> strings;
    private final boolean caseSensitive;

    public StringsCompleter() {
        this(true);
    }

    public StringsCompleter(final boolean caseSensitive) {
        this.strings = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return caseSensitive ? o1.compareTo(o2) : o1.compareToIgnoreCase(o2);
            }
        });
        this.caseSensitive = caseSensitive;
    }

    public StringsCompleter(Collection<String> strings) {
        this();
        assert (strings != null);
        this.getStrings().addAll(strings);
    }

    public StringsCompleter(String[] strings, boolean caseSensitive) {
        this(Arrays.asList(strings), caseSensitive);
    }

    public StringsCompleter(Collection<String> strings, boolean caseSensitive) {
        this(caseSensitive);
        assert (strings != null);
        this.getStrings().addAll(strings);
    }

    public StringsCompleter(String[] strings) {
        this(Arrays.asList(strings));
    }

    public SortedSet<String> getStrings() {
        return this.strings;
    }

    @Override
    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        assert (candidates != null);
        String buffer = commandLine.getCursorArgument();
        buffer = buffer == null ? "" : buffer.substring(0, commandLine.getArgumentPosition());
        if (!this.caseSensitive) {
            buffer = buffer.toLowerCase();
        }
        SortedSet<String> matches = this.getStrings().tailSet(buffer);
        for (String match : matches) {
            String s;
            String string = s = this.caseSensitive ? match : match.toLowerCase();
            if (!s.startsWith(buffer)) break;
            candidates.add(match);
        }
        if (candidates.size() == 1) {
            candidates.set(0, candidates.get(0) + " ");
        }
        return candidates.isEmpty() ? -1 : commandLine.getBufferPosition() - commandLine.getArgumentPosition();
    }
}

