/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.ArrayList;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.FrameworkStartLevel;

@Command(scope="bundle", name="list", description="Lists all installed bundles.")
@Service
public class List
extends BundlesCommand {
    @Option(name="-name", aliases={"-n"}, description="Show bundle name", required=false, multiValued=false)
    boolean showName;
    @Option(name="-l", aliases={}, description="Show the locations", required=false, multiValued=false)
    boolean showLocation;
    @Option(name="-s", description="Shows the symbolic name", required=false, multiValued=false)
    boolean showSymbolic;
    @Option(name="-u", description="Shows the update locations", required=false, multiValued=false)
    boolean showUpdate;
    @Option(name="-r", description="Shows the bundle revisions", required=false, multiValued=false)
    boolean showRevisions;
    @Option(name="-t", valueToShowInHelp="", description="Specifies the bundle threshold; bundles with a start-level less than this value will not get printed out.", required=false, multiValued=false)
    int bundleLevelThreshold = -1;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Option(name="--no-ellipsis")
    boolean noEllipsis;
    @Reference
    BundleContext bundleContext;
    @Reference
    BundleService bundleService;
    @Reference(optional=true)
    Terminal terminal;

    @Override
    protected void executeOnBundle(Bundle bundle) throws Exception {
    }

    @Override
    protected Object doExecute(java.util.List<Bundle> bundles) throws Exception {
        boolean effectiveShowName;
        if (this.noFormat) {
            this.noEllipsis = true;
        }
        this.determineBundleLevelThreshold();
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class);
        if (fsl != null) {
            System.out.println("START LEVEL " + fsl.getStartLevel() + " , List Threshold: " + this.bundleLevelThreshold);
        }
        ShellTable table = new ShellTable();
        if (!this.noEllipsis && this.showLocation && this.terminal != null && this.terminal.getWidth() > 0) {
            table.size(this.terminal.getWidth());
        }
        table.column("ID").alignRight();
        table.column("State");
        table.column("Lvl").alignRight();
        table.column("Version");
        boolean bl = effectiveShowName = this.showName || !this.showLocation && !this.showSymbolic && !this.showUpdate && !this.showRevisions;
        if (effectiveShowName) {
            table.column("Name");
        }
        if (this.showLocation) {
            table.column(new Col("Location"){

                protected String cut(String value, int size) {
                    if (List.this.showLocation && value.length() > size) {
                        String[] parts = value.split("/");
                        String cut = "";
                        int c = parts[0].length() + 4;
                        for (int idx = parts.length - 1; idx > 0 && cut.length() + c + parts[idx].length() + 1 < size; --idx) {
                            cut = "/" + parts[idx] + cut;
                        }
                        cut = parts[0] + "/..." + cut;
                        return cut;
                    }
                    return super.cut(value, size);
                }
            });
        }
        if (this.showSymbolic) {
            table.column("Symbolic name");
        }
        if (this.showUpdate) {
            table.column("Update location");
        }
        if (this.showRevisions) {
            table.column("Revisions");
        }
        for (Bundle bundle : bundles) {
            BundleInfo info = this.bundleService.getInfo(bundle);
            if (info.getStartLevel() < this.bundleLevelThreshold) continue;
            String version = info.getVersion();
            ArrayList<Object> rowData = new ArrayList<Object>();
            rowData.add(info.getBundleId());
            rowData.add(this.getStateString(info.getState()));
            rowData.add(info.getStartLevel());
            rowData.add(version);
            if (effectiveShowName) {
                String bundleName = info.getName() == null ? info.getSymbolicName() : info.getName();
                bundleName = bundleName == null ? info.getUpdateLocation() : bundleName;
                String name = bundleName + this.printFragments(info) + this.printHosts(info);
                rowData.add(name);
            }
            if (this.showLocation) {
                rowData.add(info.getUpdateLocation());
            }
            if (this.showSymbolic) {
                rowData.add(info.getSymbolicName() == null ? "<no symbolic name>" : info.getSymbolicName());
            }
            if (this.showUpdate) {
                rowData.add(info.getUpdateLocation());
            }
            if (this.showRevisions) {
                rowData.add(info.getRevisions());
            }
            Row row = table.addRow();
            row.addContent(rowData);
        }
        table.print(System.out, !this.noFormat);
        return null;
    }

    private void determineBundleLevelThreshold() {
        if (this.bundleLevelThreshold < 0) {
            this.bundleLevelThreshold = this.bundleService.getSystemBundleThreshold();
        }
    }

    private String printHosts(BundleInfo info) {
        if (info.getFragmentHosts().size() <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(", Hosts: ");
        boolean first = true;
        for (Bundle host : info.getFragmentHosts()) {
            builder.append((first ? "" : ", ") + host.getBundleId());
            first = false;
        }
        return builder.toString();
    }

    private String printFragments(BundleInfo info) {
        if (info.getFragments().size() <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(", Fragments: ");
        boolean first = true;
        for (Bundle host : info.getFragments()) {
            builder.append((first ? "" : ", ") + host.getBundleId());
            first = false;
        }
        return builder.toString();
    }

    private String getStateString(BundleState state) {
        return state == null ? "" : state.toString();
    }
}

