/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.widget;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.html.HtmlWidget;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.svl.VarResolverSession;

public abstract class Widget
implements HtmlWidget {
    public String getHtml(RestRequest req, RestResponse res) {
        return null;
    }

    public String getHtml(VarResolverSession session) {
        return this.getHtml(Widget.req(session), Widget.res(session));
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getScript(RestRequest req, RestResponse res) {
        return null;
    }

    public String getScript(VarResolverSession session) {
        return this.getScript(Widget.req(session), Widget.res(session));
    }

    public String getStyle(RestRequest req, RestResponse res) {
        return null;
    }

    public String getStyle(VarResolverSession session) {
        return this.getStyle(Widget.req(session), Widget.res(session));
    }

    private static RestRequest req(VarResolverSession session) {
        return (RestRequest)((Object)session.getBean(RestRequest.class).orElseThrow(InternalServerError::new));
    }

    private static RestResponse res(VarResolverSession session) {
        return (RestResponse)((Object)session.getBean(RestResponse.class).orElseThrow(InternalServerError::new));
    }

    protected FileFinder getFileFinder(RestRequest req) {
        return req.getStaticFiles();
    }

    protected String loadHtml(RestRequest req, String name) {
        try {
            String s = this.getFileFinder(req).getString(name, null).orElse(null);
            if (Utils.nn((Object)s)) {
                s = s.replaceAll("(?s)<!--(.*?)-->\\s*", "");
            }
            return s;
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    protected String loadHtmlWithVars(RestRequest req, RestResponse res, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadHtml(req, name));
    }

    protected String loadScript(RestRequest req, String name) {
        try {
            String s = this.getFileFinder(req).getString(name, null).orElse(null);
            if (Utils.nn((Object)s)) {
                s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
            }
            return s;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String loadScriptWithVars(RestRequest req, RestResponse res, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadScript(req, name));
    }

    protected String loadStyle(RestRequest req, String name) {
        try {
            String s = this.getFileFinder(req).getString(name, null).orElse(null);
            if (Utils.nn((Object)s)) {
                s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
            }
            return s;
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    protected String loadStyleWithVars(RestRequest req, RestResponse res, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadStyle(req, name));
    }
}

