/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.util.XMLEventAllocator;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlMetaProvider;
import org.apache.juneau.xml.XmlParserSession;

public class XmlParser
extends ReaderParser
implements XmlMetaProvider {
    public static final XmlParser DEFAULT = new XmlParser(XmlParser.create());
    protected final boolean preserveRootElement;
    protected final boolean validating;
    protected final Class<? extends XMLEventAllocator> eventAllocator;
    protected final Class<? extends XMLReporter> reporter;
    protected final Class<? extends XMLResolver> resolver;
    private final XMLEventAllocator eventAllocatorImpl;
    private final XMLReporter reporterImpl;
    private final XMLResolver resolverImpl;
    private final Map<BeanMeta<?>, XmlBeanMeta> xmlBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, XmlBeanPropertyMeta> xmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, XmlBeanPropertyMeta>();
    private final Map<ClassMeta<?>, XmlClassMeta> xmlClassMetas = new ConcurrentHashMap();

    public static Builder create() {
        return new Builder();
    }

    public XmlParser(Builder builder) {
        super(builder);
        this.eventAllocator = builder.eventAllocator;
        this.preserveRootElement = builder.preserveRootElement;
        this.reporter = builder.reporter;
        this.resolver = builder.resolver;
        this.validating = builder.validating;
        this.reporterImpl = Utils.nn(this.reporter) ? XmlParser.newInstance(this.reporter) : null;
        this.resolverImpl = Utils.nn(this.resolver) ? XmlParser.newInstance(this.resolver) : null;
        this.eventAllocatorImpl = Utils.nn(this.eventAllocator) ? XmlParser.newInstance(this.eventAllocator) : null;
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public XmlParserSession.Builder createSession() {
        return XmlParserSession.create(this);
    }

    @Override
    public XmlParserSession getSession() {
        return this.createSession().build();
    }

    @Override
    public XmlBeanMeta getXmlBeanMeta(BeanMeta<?> bm) {
        XmlBeanMeta m = this.xmlBeanMetas.get(bm);
        if (m == null) {
            m = new XmlBeanMeta(bm, this);
            this.xmlBeanMetas.put(bm, m);
        }
        return m;
    }

    @Override
    public XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        XmlBeanPropertyMeta m = this.xmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            BeanPropertyMeta dbpm = bpm.getDelegateFor();
            m = new XmlBeanPropertyMeta(dbpm, this);
            this.xmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public XmlClassMeta getXmlClassMeta(ClassMeta<?> cm) {
        XmlClassMeta m = this.xmlClassMetas.get(cm);
        if (m == null) {
            m = new XmlClassMeta(cm, this);
            this.xmlClassMetas.put(cm, m);
        }
        return m;
    }

    private static <T> T newInstance(Class<T> c) {
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    protected final XMLEventAllocator getEventAllocator() {
        return this.eventAllocatorImpl;
    }

    protected final XMLReporter getReporter() {
        return this.reporterImpl;
    }

    protected final XMLResolver getResolver() {
        return this.resolverImpl;
    }

    protected final boolean isPreserveRootElement() {
        return this.preserveRootElement;
    }

    protected final boolean isValidating() {
        return this.validating;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"eventAllocator", this.eventAllocator).a((Object)"preserveRootElement", (Object)this.preserveRootElement).a((Object)"reporter", this.reporter).a((Object)"resolver", this.resolver).a((Object)"validating", (Object)this.validating);
    }

    public static class Builder
    extends ReaderParser.Builder {
        private static final Cache<HashKey, XmlParser> CACHE = Cache.of(HashKey.class, XmlParser.class).build();
        private boolean preserveRootElement;
        private boolean validating;
        private Class<? extends XMLEventAllocator> eventAllocator;
        private Class<? extends XMLReporter> reporter;
        private Class<? extends XMLResolver> resolver;

        protected Builder() {
            this.consumes("text/xml,application/xml");
            this.preserveRootElement = (Boolean)Utils.env((String)"XmlParser.preserveRootElement", (Object)false);
            this.validating = (Boolean)Utils.env((String)"XmlParser.validating", (Object)false);
            this.eventAllocator = null;
            this.reporter = null;
            this.resolver = null;
        }

        protected Builder(Builder copyFrom) {
            super((ReaderParser.Builder)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.preserveRootElement = copyFrom.preserveRootElement;
            this.validating = copyFrom.validating;
            this.eventAllocator = copyFrom.eventAllocator;
            this.reporter = copyFrom.reporter;
            this.resolver = copyFrom.resolver;
        }

        protected Builder(XmlParser copyFrom) {
            super((ReaderParser)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.preserveRootElement = copyFrom.preserveRootElement;
            this.validating = copyFrom.validating;
            this.eventAllocator = copyFrom.eventAllocator;
            this.reporter = copyFrom.reporter;
            this.resolver = copyFrom.resolver;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder autoCloseStreams() {
            super.autoCloseStreams();
            return this;
        }

        @Override
        public Builder autoCloseStreams(boolean value) {
            super.autoCloseStreams(value);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public XmlParser build() {
            return this.cache((Cache)CACHE).build(XmlParser.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder consumes(String value) {
            super.consumes(value);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder debugOutputLines(int value) {
            super.debugOutputLines(value);
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        public Builder eventAllocator(Class<? extends XMLEventAllocator> value) {
            this.eventAllocator = value;
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of((Object[])new Object[]{super.hashKey(), this.preserveRootElement, this.validating, this.eventAllocator, this.reporter, this.resolver});
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder listener(Class<? extends ParserListener> value) {
            super.listener((Class)value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        public Builder preserveRootElement() {
            return this.preserveRootElement(true);
        }

        public Builder preserveRootElement(boolean value) {
            this.preserveRootElement = value;
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        public Builder reporter(Class<? extends XMLReporter> value) {
            this.reporter = value;
            return this;
        }

        public Builder resolver(Class<? extends XMLResolver> value) {
            this.resolver = value;
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder strict() {
            super.strict();
            return this;
        }

        @Override
        public Builder strict(boolean value) {
            super.strict(value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder swaps(Object ... values) {
            super.swaps(values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder trimStrings() {
            super.trimStrings();
            return this;
        }

        @Override
        public Builder trimStrings(boolean value) {
            super.trimStrings(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder unbuffered() {
            super.unbuffered();
            return this;
        }

        @Override
        public Builder unbuffered(boolean value) {
            super.unbuffered(value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        public Builder validating() {
            return this.validating(true);
        }

        public Builder validating(boolean value) {
            this.validating = value;
            return this;
        }
    }
}

