/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="propertyName,mapping,*")
@FluentSetters
public class Discriminator
extends OpenApiElement {
    private String propertyName;
    private Map<String, String> mapping;

    public Discriminator() {
    }

    public Discriminator(Discriminator copyFrom) {
        super(copyFrom);
        this.propertyName = copyFrom.propertyName;
        this.mapping = copyFrom.mapping == null ? null : new LinkedHashMap<String, String>(copyFrom.mapping);
    }

    public Discriminator copy() {
        return new Discriminator(this);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Discriminator setPropertyName(String value) {
        this.propertyName = value;
        return this;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }

    public Discriminator setMapping(Map<String, String> value) {
        this.mapping = CollectionUtils.copyOf(value);
        return this;
    }

    public Discriminator addMapping(String key, String value) {
        this.mapping = CollectionUtils.mapBuilder(this.mapping).sparse().add(key, value).build();
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "propertyName": {
                return ConverterUtils.toType(this.getPropertyName(), type);
            }
            case "mapping": {
                return ConverterUtils.toType(this.getMapping(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Discriminator set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "propertyName": {
                return this.setPropertyName(StringUtils.stringify(value));
            }
            case "mapping": {
                return this.setMapping(CollectionUtils.mapBuilder(String.class, String.class, new Type[0]).sparse().addAny(value).build());
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.propertyName != null, "propertyName").addIf(this.mapping != null, "mapping").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

