/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.NameProperty;
import org.apache.juneau.annotation.TargetedAnnotationImpl;
import org.apache.juneau.annotation.TargetedAnnotationMFBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class NamePropertyAnnotation {
    public static final NameProperty DEFAULT = NamePropertyAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(String ... on) {
        return NamePropertyAnnotation.create().on(on);
    }

    public static NameProperty copy(NameProperty a, VarResolverSession r) {
        return NamePropertyAnnotation.create().on(r.resolve(a.on())).build();
    }

    public static class Builder
    extends TargetedAnnotationMFBuilder {
        protected Builder() {
            super(NameProperty.class);
        }

        public NameProperty build() {
            return new Impl(this);
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public NameProperty[] value();
    }

    public static class Applier
    extends AnnotationApplier<NameProperty, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(NameProperty.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<NameProperty> ai, BeanContext.Builder b) {
            NameProperty a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on())) {
                return;
            }
            b.annotations(NamePropertyAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationImpl
    implements NameProperty {
        Impl(Builder b) {
            super(b);
            this.postConstruct();
        }
    }
}

