/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.juneau.internal.ReverseIterable;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.WriterSerializer;

public final class AList<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;

    public AList() {
    }

    public AList(int capacity) {
        super(capacity);
    }

    public AList(Collection<T> c) {
        super(c == null ? Collections.emptyList() : c);
    }

    public static <T> AList<T> of() {
        return new AList<T>();
    }

    @SafeVarargs
    public static <T> AList<T> of(T ... t) {
        return new AList<T>(t.length).a(t);
    }

    public static <T> AList<T> ofa(T ... t) {
        return new AList<T>(t.length).a(t);
    }

    public static <T> AList<T> of(Collection<T> c) {
        c = c == null ? Collections.emptyList() : c;
        return new AList<T>(c.size()).aa(c);
    }

    public static <T> AList<T> nullable(Collection<T> c) {
        return c == null ? null : AList.of(c);
    }

    public static <T> List<T> unmodifiable(T ... t) {
        return t.length == 0 ? Collections.emptyList() : AList.of(t).unmodifiable();
    }

    public static <T> List<T> unmodifiable(Collection<T> c) {
        if (c == null || c.isEmpty()) {
            return Collections.emptyList();
        }
        return new AList<T>(c.size()).aa(c).unmodifiable();
    }

    public AList<T> a(T t) {
        this.add(t);
        return this;
    }

    public AList<T> a(T ... t) {
        Collections.addAll(this, t);
        return this;
    }

    public AList<T> aa(Collection<? extends T> c) {
        if (c != null) {
            this.addAll(c);
        }
        return this;
    }

    public AList<T> aif(boolean b, T val) {
        if (b) {
            this.a(val);
        }
        return this;
    }

    public AList<T> aifnn(T ... t) {
        for (T o2 : t) {
            if (o2 == null) continue;
            this.a(o2);
        }
        return this;
    }

    public AList<T> arev(List<? extends T> c) {
        ListIterator<T> i = c.listIterator(c.size());
        while (i.hasPrevious()) {
            this.add(i.previous());
        }
        return this;
    }

    public AList<T> arev(T[] c) {
        for (int i = c.length - 1; i >= 0; --i) {
            this.add(c[i]);
        }
        return this;
    }

    public List<T> unmodifiable() {
        return this.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this);
    }

    public <T2> T2[] asArrayOf(Class<T2> c) {
        return this.toArray((Object[])Array.newInstance(c, this.size()));
    }

    public Iterable<T> riterable() {
        return new ReverseIterable(this);
    }

    public String asString(WriterSerializer ws) {
        return ws.toString(this);
    }

    public String asString() {
        return SimpleJsonSerializer.DEFAULT.toString(this);
    }

    @Override
    public String toString() {
        return this.asString(SimpleJsonSerializer.DEFAULT);
    }
}

