/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;

public interface JohnzonJsonParser
extends JsonParser {
    public boolean isNotTooLong();

    default public JsonParser.Event current() {
        throw new UnsupportedOperationException("getting the current JsonParser Event is not supported");
    }

    public static class JohnzonJsonParserWrapper
    implements JohnzonJsonParser {
        private final JsonParser jsonParser;

        public JohnzonJsonParserWrapper(JsonParser jsonParser) {
            this.jsonParser = jsonParser;
        }

        @Override
        public boolean isNotTooLong() {
            return true;
        }

        public boolean hasNext() {
            return this.jsonParser.hasNext();
        }

        public JsonParser.Event next() {
            return this.jsonParser.next();
        }

        public String getString() {
            return this.jsonParser.getString();
        }

        public boolean isIntegralNumber() {
            return this.jsonParser.isIntegralNumber();
        }

        public int getInt() {
            return this.jsonParser.getInt();
        }

        public long getLong() {
            return this.jsonParser.getLong();
        }

        public BigDecimal getBigDecimal() {
            return this.jsonParser.getBigDecimal();
        }

        public JsonLocation getLocation() {
            return this.jsonParser.getLocation();
        }

        public void close() {
            this.jsonParser.close();
        }

        public JsonObject getObject() {
            return this.jsonParser.getObject();
        }

        public JsonValue getValue() {
            return this.jsonParser.getValue();
        }

        public JsonArray getArray() {
            return this.jsonParser.getArray();
        }

        public Stream<JsonValue> getArrayStream() {
            return this.jsonParser.getArrayStream();
        }

        public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
            return this.jsonParser.getObjectStream();
        }

        public Stream<JsonValue> getValueStream() {
            return this.jsonParser.getValueStream();
        }

        public void skipArray() {
            this.jsonParser.skipArray();
        }

        public void skipObject() {
            this.jsonParser.skipObject();
        }
    }
}

