/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartData.processors;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.interfaces.IScatterPlotDataSeries;
import org.jCharts.chartData.interfaces.IScatterPlotDataSet;
import org.jCharts.chartData.processors.AxisChartDataProcessor;
import org.jCharts.types.ChartType;

public final class ScatterPlotDataProcessor
extends AxisChartDataProcessor {
    private double yMax;
    private double yMin;

    public void processData(AxisChart axisChart, FontRenderContext fontRenderContext) {
        IScatterPlotDataSeries iScatterPlotDataSeries = (IScatterPlotDataSeries)axisChart.getIAxisDataSeries();
        this.processDataSet(iScatterPlotDataSeries);
    }

    private void processDataSet(IScatterPlotDataSeries iScatterPlotDataSeries) {
        IScatterPlotDataSet iScatterPlotDataSet = (IScatterPlotDataSet)iScatterPlotDataSeries.getIAxisPlotDataSet(ChartType.SCATTER_PLOT);
        int n = 0;
        while (n < iScatterPlotDataSet.getNumberOfDataSets()) {
            int n2 = 0;
            while (n2 < iScatterPlotDataSet.getNumberOfDataItems()) {
                Point2D.Double double_ = iScatterPlotDataSet.getValue(n, n2);
                if (double_ != null) {
                    if (double_.getX() > super.getMaxValue()) {
                        super.setMaxValue(double_.getX());
                    }
                    if (double_.getX() < super.getMinValue()) {
                        super.setMinValue(double_.getX());
                    }
                    if (double_.getY() > this.getyMax()) {
                        this.setyMax(double_.getY());
                    }
                    if (double_.getY() < this.getyMin()) {
                        this.setyMin(double_.getY());
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public double getyMax() {
        return this.yMax;
    }

    public void setyMax(double d) {
        this.yMax = d;
    }

    public double getyMin() {
        return this.yMin;
    }

    public void setyMin(double d) {
        this.yMin = d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(":  xMin= " + super.getMinValue());
        stringBuffer.append(" xMax= " + super.getMaxValue());
        stringBuffer.append("  yMin= " + this.yMin);
        stringBuffer.append(" yMax= " + this.yMax);
        return stringBuffer.toString();
    }
}

