/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.http.control.StaticHost;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TextParseException;

public class DNSCacheManager
extends ConfigTestElement
implements TestIterationListener,
Serializable,
DnsResolver {
    private static final long serialVersionUID = 2122L;
    private static final Logger log = LoggerFactory.getLogger(DNSCacheManager.class);
    public static final boolean DEFAULT_CLEAR_CACHE_EACH_ITER = false;
    private static final String CLEAR_CACHE_EACH_ITER = "DNSCacheManager.clearEachIteration";
    private static final String SERVERS = "DNSCacheManager.servers";
    private static final String HOSTS = "DNSCacheManager.hosts";
    private static final String IS_CUSTOM_RESOLVER = "DNSCacheManager.isCustomResolver";
    private static final boolean DEFAULT_IS_CUSTOM_RESOLVER = false;
    private final transient Cache lookupCache;
    private final transient SystemDefaultDnsResolver systemDefaultDnsResolver;
    final Map<String, InetAddress[]> cache;
    private transient Resolver resolver;
    private transient int timeoutMs;
    transient boolean initFailed;

    public DNSCacheManager() {
        this.setProperty((JMeterProperty)new CollectionProperty(SERVERS, new ArrayList()));
        this.systemDefaultDnsResolver = new SystemDefaultDnsResolver();
        this.cache = new LinkedHashMap<String, InetAddress[]>();
        this.lookupCache = new Cache();
        this.lookupCache.setMaxCache(0);
        this.lookupCache.setMaxEntries(0);
    }

    public Object clone() {
        DNSCacheManager clone = (DNSCacheManager)super.clone();
        clone.resolver = this.createResolver();
        return clone;
    }

    @VisibleForTesting
    Resolver getResolver() {
        return this.resolver;
    }

    private Resolver createResolver() {
        CollectionProperty dnsServers = this.getServers();
        try {
            String[] serverNames = new String[dnsServers.size()];
            int index = 0;
            for (JMeterProperty jMeterProperty : dnsServers) {
                serverNames[index] = jMeterProperty.getStringValue();
                ++index;
            }
            ExtendedResolver result = new ExtendedResolver(serverNames);
            if (log.isDebugEnabled()) {
                log.debug("Using DNS Resolvers: {}", Arrays.asList(result.getResolvers()));
            }
            result.setLoadBalance(true);
            return result;
        }
        catch (UnknownHostException uhe) {
            this.initFailed = true;
            log.warn("Failed to create Extended resolver: {}", (Object)uhe.getMessage(), (Object)uhe);
            return null;
        }
    }

    public InetAddress[] resolve(String host) throws UnknownHostException {
        InetAddress[] result = this.cache.get(host);
        if (result != null || this.cache.containsKey(host)) {
            DNSCacheManager.logCache("hit", host, result);
            return result;
        }
        if (this.isStaticHost(host)) {
            InetAddress[] staticAddresses = this.fromStaticHost(host);
            DNSCacheManager.logCache("miss", host, staticAddresses);
            this.cache.put(host, staticAddresses);
            return staticAddresses;
        }
        InetAddress[] addresses = this.requestLookup(host);
        DNSCacheManager.logCache("miss", host, addresses);
        this.cache.put(host, addresses);
        return addresses;
    }

    private static void logCache(String hitOrMiss, String host, InetAddress[] addresses) {
        if (log.isDebugEnabled()) {
            log.debug("Cache {} thread#{}: {} => {}", new Object[]{hitOrMiss, JMeterContextService.getContext().getThreadNum(), host, Arrays.toString(addresses)});
        }
    }

    private boolean isStaticHost(String host) {
        JMeterProperty p = this.getProperty(HOSTS);
        if (p instanceof NullProperty) {
            this.removeProperty(HOSTS);
            return false;
        }
        CollectionProperty property = (CollectionProperty)p;
        for (JMeterProperty jMeterProperty : property) {
            StaticHost entry;
            TestElementProperty possibleEntry = (TestElementProperty)jMeterProperty;
            if (log.isDebugEnabled()) {
                log.debug("Look for {} at {}: {}", new Object[]{host, possibleEntry.getObjectValue(), possibleEntry.getObjectValue().getClass()});
            }
            if (!(entry = (StaticHost)possibleEntry.getObjectValue()).getName().equalsIgnoreCase(host)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found static host: {} => {}", (Object)host, (Object)entry.getAddress());
            }
            return true;
        }
        log.debug("No static host found for {}", (Object)host);
        return false;
    }

    private InetAddress[] fromStaticHost(String host) {
        JMeterProperty p = this.getProperty(HOSTS);
        if (p instanceof NullProperty) {
            this.removeProperty(HOSTS);
            return new InetAddress[0];
        }
        CollectionProperty property = (CollectionProperty)p;
        for (JMeterProperty jMeterProperty : property) {
            StaticHost entry = (StaticHost)jMeterProperty.getObjectValue();
            if (!entry.getName().equals(host)) continue;
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            for (String address : entry.getAddress().split("\\s*,\\s*")) {
                try {
                    InetAddress[] requestLookup = this.requestLookup(address);
                    if (requestLookup == null) {
                        DNSCacheManager.addAsLiteralAddress(addresses, address);
                        continue;
                    }
                    addresses.addAll(Arrays.asList(requestLookup));
                }
                catch (UnknownHostException e) {
                    DNSCacheManager.addAsLiteralAddress(addresses, address);
                    log.warn("Couldn't resolve static address {} for host {}", new Object[]{address, host, e});
                }
            }
            return addresses.toArray(new InetAddress[addresses.size()]);
        }
        return new InetAddress[0];
    }

    private static void addAsLiteralAddress(List<? super InetAddress> addresses, String address) {
        try {
            addresses.add(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            log.info("Couldn't convert {} as literal address to InetAddress", (Object)address, (Object)e);
        }
    }

    private InetAddress[] requestLookup(String host) throws UnknownHostException {
        if (this.isCustomResolver()) {
            ExtendedResolver extendedResolver = this.getOrCreateResolver();
            if (extendedResolver == null) {
                throw new UnknownHostException("Could not resolve host:" + host + ", failed to initialize resolver or no resolver found");
            }
            if (extendedResolver.getResolvers().length > 0) {
                return this.customRequestLookup(host);
            }
        }
        InetAddress[] addresses = this.systemDefaultDnsResolver.resolve(host);
        DNSCacheManager.logCache("miss (resolved with system resolver)", host, addresses);
        return addresses;
    }

    private InetAddress[] customRequestLookup(String host) throws UnknownHostException {
        InetAddress[] addresses = null;
        try {
            Lookup lookup = new Lookup(host, 1);
            lookup.setCache(this.lookupCache);
            if (this.timeoutMs > 0) {
                this.resolver.setTimeout(this.timeoutMs / 1000, this.timeoutMs % 1000);
            }
            lookup.setResolver(this.resolver);
            Record[] records = lookup.run();
            if (records == null || records.length == 0) {
                throw new UnknownHostException("Failed to resolve host name: " + host);
            }
            addresses = new InetAddress[records.length];
            for (int i = 0; i < records.length; ++i) {
                addresses[i] = ((ARecord)records[i]).getAddress();
            }
        }
        catch (TextParseException tpe) {
            log.debug("Failed to create Lookup object for host:{}, error message:{}", (Object)host, (Object)tpe.toString());
        }
        return addresses;
    }

    private ExtendedResolver getOrCreateResolver() {
        if (this.resolver == null && !this.initFailed) {
            this.resolver = this.createResolver();
        }
        return (ExtendedResolver)this.resolver;
    }

    public void testIterationStart(LoopIterationEvent event) {
        if (this.isClearEachIteration()) {
            this.cache.clear();
        }
    }

    public void clear() {
        super.clear();
        this.clearServers();
        this.clearHosts();
        this.cache.clear();
        this.initFailed = false;
        this.resolver = null;
    }

    private void clearServers() {
        log.debug("Clear all servers from store");
        this.setProperty((JMeterProperty)new CollectionProperty(SERVERS, new ArrayList()));
    }

    public void addServer(String dnsServer) {
        this.getServers().addItem((Object)dnsServer);
    }

    public CollectionProperty getServers() {
        return (CollectionProperty)this.getProperty(SERVERS);
    }

    private void clearHosts() {
        log.debug("Clear all hosts from store");
        this.removeProperty(HOSTS);
        this.cache.clear();
    }

    public void addHost(String dnsHost, String addresses) {
        this.getHosts().addItem((Object)new StaticHost(dnsHost, addresses));
        this.cache.clear();
    }

    public CollectionProperty getHosts() {
        if (this.getProperty(HOSTS) instanceof NullProperty) {
            this.setProperty((JMeterProperty)new CollectionProperty(HOSTS, new ArrayList()));
        }
        return (CollectionProperty)this.getProperty(HOSTS);
    }

    public boolean isClearEachIteration() {
        return this.getPropertyAsBoolean(CLEAR_CACHE_EACH_ITER, false);
    }

    public void setClearEachIteration(boolean clear) {
        this.setProperty((JMeterProperty)new BooleanProperty(CLEAR_CACHE_EACH_ITER, clear));
    }

    public boolean isCustomResolver() {
        return this.getPropertyAsBoolean(IS_CUSTOM_RESOLVER, false);
    }

    public void setCustomResolver(boolean isCustomResolver) {
        this.setProperty(IS_CUSTOM_RESOLVER, isCustomResolver);
    }

    void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    int getTimeoutMs() {
        return this.timeoutMs;
    }
}

