/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBeanHelper {
    protected static final Logger log = LoggerFactory.getLogger(TestBeanHelper.class);
    private static final ClassValue<List<CachedPropertyDescriptor>> GOOD_PROPS = new ClassValue<List<CachedPropertyDescriptor>>(){

        @Override
        protected List<CachedPropertyDescriptor> computeValue(Class type) {
            PropertyDescriptor[] descs;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(type);
                descs = beanInfo.getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                log.error("Couldn't set properties for {}", (Object)type, (Object)e);
                throw new IllegalArgumentException("Couldn't set properties for " + type, e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Preparing {}", (Object)type);
            }
            ArrayList<CachedPropertyDescriptor> descriptors = new ArrayList<CachedPropertyDescriptor>(descs.length);
            for (PropertyDescriptor desc : descs) {
                if (TestBeanHelper.isDescriptorIgnored(desc)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Ignoring property '{}' in {}", (Object)desc.getName(), (Object)type.getCanonicalName());
                    continue;
                }
                Method writeMethod = desc.getWriteMethod();
                if (writeMethod == null) continue;
                descriptors.add(new CachedPropertyDescriptor(desc));
            }
            return descriptors;
        }
    };

    public static void prepare(TestElement el) {
        if (!(el instanceof TestBean)) {
            return;
        }
        Object[] tmp = new Object[1];
        try {
            for (CachedPropertyDescriptor desc : GOOD_PROPS.get(el.getClass())) {
                Object value;
                JMeterProperty jprop;
                Class<?> type = desc.propertyType;
                try {
                    jprop = el.getProperty(desc.descriptor.getName());
                    value = TestBeanHelper.unwrapProperty(desc.descriptor, jprop, type);
                }
                catch (OutOfMemoryError | StackOverflowError e) {
                    throw e;
                }
                catch (Throwable e) {
                    String elementName;
                    try {
                        elementName = el.getName();
                    }
                    catch (Throwable ignore) {
                        elementName = el.getClass().getName();
                    }
                    throw new IllegalStateException("Can't retrieve property '" + desc.descriptor.getName() + "' of element " + elementName, e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Setting {}={}", (Object)jprop.getName(), value);
                }
                if (value == null && type.isPrimitive()) continue;
                Method writeMethod = desc.writeMethod;
                tmp[0] = value;
                TestBeanHelper.invokeOrBailOut(el, writeMethod, tmp);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            log.error("Couldn't set properties for {}", el.getClass());
            throw ule;
        }
    }

    private static Object unwrapProperty(PropertyDescriptor desc, JMeterProperty jprop, Class<?> type) {
        Object value;
        if (jprop instanceof TestElementProperty) {
            TestElement te = ((TestElementProperty)jprop).getElement();
            if (te instanceof TestBean) {
                TestBeanHelper.prepare(te);
            }
            value = te;
        } else {
            value = jprop instanceof MultiProperty ? TestBeanHelper.unwrapCollection((MultiProperty)jprop, (String)desc.getValue("tableObject.classname")) : (jprop instanceof NullProperty && !Boolean.TRUE.equals(desc.getValue("notUndefined")) ? null : Converter.convert((Object)jprop.getStringValue(), type));
        }
        return value;
    }

    private static Object unwrapCollection(MultiProperty prop, String type) {
        if (prop instanceof CollectionProperty) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (JMeterProperty jMeterProperty : prop) {
                try {
                    values.add(TestBeanHelper.unwrapProperty(null, jMeterProperty, Class.forName(type)));
                }
                catch (Exception e) {
                    log.error("Couldn't convert object: {} to {}", new Object[]{prop.getObjectValue(), type, e});
                }
            }
            return values;
        }
        return null;
    }

    private static Object invokeOrBailOut(Object invokee, Method method, Object[] params) {
        try {
            return method.invoke(invokee, params);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new Error(TestBeanHelper.createMessage(invokee, method, params), e);
        }
        catch (InvocationTargetException e) {
            throw new Error(TestBeanHelper.createMessage(invokee, method, params), e.getCause());
        }
    }

    private static String createMessage(Object invokee, Method method, Object[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append("This should never happen. Tried to invoke:\n");
        sb.append(invokee.getClass().getName());
        sb.append("#");
        sb.append(method.getName());
        sb.append("(");
        for (Object o : params) {
            if (o != null) {
                sb.append(o.getClass().getSimpleName());
                sb.append(' ');
            }
            sb.append(o);
            sb.append(' ');
        }
        sb.append(")");
        return sb.toString();
    }

    public static boolean isDescriptorIgnored(PropertyDescriptor descriptor) {
        return descriptor.isHidden() || descriptor.isExpert() && !JMeterUtils.isExpertMode() || descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null;
    }

    static class CachedPropertyDescriptor {
        final PropertyDescriptor descriptor;
        final Method writeMethod;
        final Class<?> propertyType;

        CachedPropertyDescriptor(PropertyDescriptor descriptor) {
            this.descriptor = descriptor;
            this.writeMethod = descriptor.getWriteMethod();
            this.propertyType = descriptor.getPropertyType();
        }
    }
}

