/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.graphics.Animator;
import com.github.weisj.darklaf.ui.scrollpane.DarkScrollBarListener;
import com.github.weisj.darklaf.ui.scrollpane.DarkScrollBarUI;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class DarkMacScrollBarUI
extends DarkScrollBarUI {
    private boolean hideScrollBar;

    public static ComponentUI createUI(JComponent c) {
        return new DarkMacScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.hideScrollBar = UIManager.getBoolean("ScrollBar.macos.hideScrollBar");
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle bounds) {
    }

    @Override
    protected void paintMaxiThumb(Graphics2D g, Rectangle rect) {
        GraphicsContext context = GraphicsUtil.setupStrokePainting((Graphics)g);
        g.setComposite(COMPOSITE.derive(this.thumbAlpha));
        boolean horizontal = this.scrollbar.getOrientation() == 0;
        int ins = 2;
        RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float();
        int width = rect.width - 2 * ins;
        int height = rect.height - 2 * ins;
        int x = rect.x + ins;
        int y = rect.y + ins;
        if (this.hideScrollBar) {
            float animationState = this.scrollBarListener.getTrackState();
            if (horizontal) {
                int newHeight = Math.round((float)height * animationState);
                y += height - newHeight;
                height = newHeight;
            } else {
                int newWidth = Math.round((float)width * animationState);
                if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    x += width - newWidth;
                }
                width = newWidth;
            }
        }
        int arc = horizontal ? height : width;
        ((RoundRectangle2D)roundRect).setRoundRect(x, y, width, height, arc, arc);
        g.setColor(this.getThumbColor());
        g.fill(roundRect);
        g.setColor(this.getThumbBorderColor());
        g.draw(roundRect);
        context.restore();
    }

    protected DarkScrollBarListener<DarkMacScrollBarUI> createScrollBarListener() {
        return new MacScrollBarListener(this.scrollbar, this);
    }

    private static class MacScrollBarListener
    extends DarkScrollBarListener<DarkMacScrollBarUI> {
        private final Timer hideTimer;

        public MacScrollBarListener(JScrollBar scrollbar, DarkMacScrollBarUI ui) {
            super(scrollbar, ui);
            int hideDelay = this.getTrackFadeOutDelay();
            this.hideTimer = new Timer(hideDelay, e -> {
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, scrollbar);
                this.mouseOverTrack = scrollbar.contains(p);
                this.resetTrackAnimator();
            });
            this.hideTimer.setRepeats(false);
        }

        @Override
        protected boolean animateTrackOnScroll(JScrollBar scrollBar) {
            return ((DarkMacScrollBarUI)this.ui).hideScrollBar;
        }

        @Override
        protected Animator createTrackFadeinAnimator() {
            return ((DarkMacScrollBarUI)this.ui).hideScrollBar ? super.createTrackFadeinAnimator() : null;
        }

        @Override
        protected Animator createTrackFadeoutAnimator() {
            return ((DarkMacScrollBarUI)this.ui).hideScrollBar ? super.createTrackFadeoutAnimator() : null;
        }

        @Override
        protected int getTrackFadeOutDelay() {
            return UIManager.getInt("ScrollBar.macos.hideDelay");
        }

        @Override
        protected void runOnScrollTrackAnimation() {
            super.runOnScrollTrackAnimation();
            this.hideTimer.stop();
            this.hideTimer.start();
        }

        @Override
        protected void resetTrackAnimator() {
            this.hideTimer.stop();
            super.resetTrackAnimator();
        }
    }
}

