/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.backends.jpa.JPAConfiguration;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jpa.mail.JPAAnnotationMapper;
import org.apache.james.mailbox.jpa.mail.JPAAttachmentMapper;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.jpa.mail.JPAMessageMapper;
import org.apache.james.mailbox.jpa.mail.JPAModSeqProvider;
import org.apache.james.mailbox.jpa.mail.JPAUidProvider;
import org.apache.james.mailbox.jpa.user.JPASubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class JPAMailboxSessionMapperFactory
extends MailboxSessionMapperFactory
implements AttachmentMapperFactory {
    private final EntityManagerFactory entityManagerFactory;
    private final JPAUidProvider uidProvider;
    private final JPAModSeqProvider modSeqProvider;
    private final AttachmentMapper attachmentMapper;
    private final JPAConfiguration jpaConfiguration;

    @Inject
    public JPAMailboxSessionMapperFactory(EntityManagerFactory entityManagerFactory, JPAUidProvider uidProvider, JPAModSeqProvider modSeqProvider, JPAConfiguration jpaConfiguration) {
        this.entityManagerFactory = entityManagerFactory;
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
        EntityManagerUtils.safelyClose((EntityManager)this.createEntityManager());
        this.attachmentMapper = new JPAAttachmentMapper(entityManagerFactory);
        this.jpaConfiguration = jpaConfiguration;
    }

    public MailboxMapper createMailboxMapper(MailboxSession session) {
        return new JPAMailboxMapper(this.entityManagerFactory);
    }

    public MessageMapper createMessageMapper(MailboxSession session) {
        return new JPAMessageMapper(this.uidProvider, this.modSeqProvider, this.entityManagerFactory, this.jpaConfiguration);
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession session) {
        throw new NotImplementedException("not implemented");
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) {
        return new JPASubscriptionMapper(this.entityManagerFactory);
    }

    private EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession session) {
        return new JPAAnnotationMapper(this.entityManagerFactory);
    }

    public UidProvider getUidProvider(MailboxSession session) {
        return this.uidProvider;
    }

    public ModSeqProvider getModSeqProvider(MailboxSession session) {
        return this.modSeqProvider;
    }

    public AttachmentMapper createAttachmentMapper(MailboxSession session) {
        return new JPAAttachmentMapper(this.entityManagerFactory);
    }

    public AttachmentMapper getAttachmentMapper(MailboxSession session) {
        return this.attachmentMapper;
    }
}

