/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.mailbox.model.MailboxMetaData;

public abstract class AbstractListingResponse {
    private final MailboxMetaData.Children children;
    private final MailboxMetaData.Selectability selectability;
    private final String name;
    private final char hierarchyDelimiter;
    private final MailboxType type;

    public AbstractListingResponse(MailboxMetaData.Children children, MailboxMetaData.Selectability selectability, String name, char hierarchyDelimiter, MailboxType type) {
        this.children = children;
        this.selectability = selectability;
        this.name = name;
        this.hierarchyDelimiter = hierarchyDelimiter;
        this.type = type;
    }

    public final char getHierarchyDelimiter() {
        return this.hierarchyDelimiter;
    }

    public final String getName() {
        return this.name;
    }

    public MailboxType getType() {
        return this.type;
    }

    public abstract String getTypeAsString();

    public MailboxMetaData.Children getChildren() {
        return this.children;
    }

    public MailboxMetaData.Selectability getSelectability() {
        return this.selectability;
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractListingResponse) {
            AbstractListingResponse that = (AbstractListingResponse)other;
            return Objects.equals(this.children, that.children) && Objects.equals(this.selectability, that.selectability) && Objects.equals(this.name, that.name) && Objects.equals(Character.valueOf(this.hierarchyDelimiter), Character.valueOf(that.hierarchyDelimiter)) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.children, this.selectability, this.name, Character.valueOf(this.hierarchyDelimiter), this.type});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("children", (Object)this.children).add("selectability", (Object)this.selectability).add("name", (Object)this.name).add("hierarchyDelimiter", this.hierarchyDelimiter).add("type", (Object)this.type).toString();
    }
}

