/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.tasks;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.services.TasksCleanupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksCleanupTask
implements Task {
    public static final Logger LOGGER = LoggerFactory.getLogger(TasksCleanupTask.class);
    public static final TaskType TASK_TYPE = TaskType.of((String)"tasks-cleanup");
    private final TasksCleanupService service;
    private final Instant beforeDate;
    private final TasksCleanupService.Context context;

    public TasksCleanupTask(TasksCleanupService service, Instant beforeDate) {
        this.service = service;
        this.beforeDate = beforeDate;
        this.context = new TasksCleanupService.Context();
    }

    public Task.Result run() throws InterruptedException {
        return (Task.Result)this.service.removeBeforeDate(this.beforeDate, this.context).block();
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        TasksCleanupService.Context.Snapshot snapshot = this.context.snapshot();
        return Optional.of(new Details(Clock.systemUTC().instant(), snapshot.getRemovedTasksCount(), snapshot.getProcessedTaskCount(), this.beforeDate));
    }

    public Instant getBeforeDate() {
        return this.beforeDate;
    }

    public static class Details
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant instant;
        private final long removedTasksCount;
        private final long processedTaskCount;
        private final Instant olderThan;

        public Details(Instant instant, long removedTasksCount, long processedTaskCount, Instant olderThan) {
            this.instant = instant;
            this.removedTasksCount = removedTasksCount;
            this.processedTaskCount = processedTaskCount;
            this.olderThan = olderThan;
        }

        public Instant timestamp() {
            return this.instant;
        }

        public long getRemovedTasksCount() {
            return this.removedTasksCount;
        }

        public long getProcessedTaskCount() {
            return this.processedTaskCount;
        }

        public Instant getOlderThan() {
            return this.olderThan;
        }
    }
}

