/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.change;

import com.google.common.collect.ImmutableList;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.postgres.change.PostgresMailboxChangeDataDefinition;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.jooq.OrderField;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMailboxChangeDAO {
    private final PostgresExecutor postgresExecutor;

    public PostgresMailboxChangeDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<Void> insert(MailboxChange change) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.TABLE_NAME).set(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.ACCOUNT_ID, (Object)change.getAccountId().getIdentifier()).set(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE, (Object)change.getState().getValue()).set(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.IS_SHARED, (Object)change.isShared()).set(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.IS_COUNT_CHANGE, (Object)change.isCountChange()).set(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.CREATED, (Object)this.toUUIDArray(change.getCreated())).set(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.UPDATED, (Object)this.toUUIDArray(change.getUpdated())).set(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.DESTROYED, (Object)this.toUUIDArray(change.getDestroyed())).set(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.DATE, (Object)change.getDate().toOffsetDateTime())));
    }

    public Flux<MailboxChange> getAllChanges(AccountId accountId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.TABLE_NAME).where(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier())))).map(record -> this.readRecord((Record)record, accountId));
    }

    public Flux<MailboxChange> getChangesSince(AccountId accountId, State state) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.TABLE_NAME).where(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier())).and(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE.greaterOrEqual((Object)state.getValue())).orderBy(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE))).map(record -> this.readRecord((Record)record, accountId));
    }

    public Mono<State> latestState(AccountId accountId) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE).from(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.TABLE_NAME).where(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier())).orderBy((OrderField)PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE.desc()).limit((Number)1))).map(record -> State.of((UUID)((UUID)record.get(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE))));
    }

    public Mono<State> latestStateNotDelegated(AccountId accountId) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE).from(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.TABLE_NAME).where(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier())).and(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.IS_SHARED.eq((Object)false)).orderBy((OrderField)PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE.desc()).limit((Number)1))).map(record -> State.of((UUID)((UUID)record.get(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE))));
    }

    private UUID[] toUUIDArray(List<MailboxId> mailboxIds) {
        return (UUID[])mailboxIds.stream().map(PostgresMailboxId.class::cast).map(PostgresMailboxId::asUuid).toArray(UUID[]::new);
    }

    private MailboxChange readRecord(Record record, AccountId accountId) {
        return MailboxChange.builder().accountId(accountId).state(State.of((UUID)((UUID)record.get(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.STATE)))).date(((OffsetDateTime)record.get(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.DATE)).toZonedDateTime()).isCountChange(((Boolean)record.get(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.IS_COUNT_CHANGE)).booleanValue()).shared(((Boolean)record.get(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.IS_SHARED)).booleanValue()).created(this.toMailboxIds((UUID[])record.get(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.CREATED))).updated(this.toMailboxIds((UUID[])record.get(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.UPDATED))).destroyed(this.toMailboxIds((UUID[])record.get(PostgresMailboxChangeDataDefinition.PostgresMailboxChangeTable.DESTROYED))).build();
    }

    private List<MailboxId> toMailboxIds(UUID[] uuids) {
        return (List)Arrays.stream(uuids).map(PostgresMailboxId::of).collect(ImmutableList.toImmutableList());
    }
}

