/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.SCRAMBindRequest;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SCRAMSHA1BindRequest
extends SCRAMBindRequest {
    @NotNull
    public static final String SCRAM_SHA_1_MECHANISM_NAME = "SCRAM-SHA-1";
    private static final long serialVersionUID = -1807244826649889525L;

    public SCRAMSHA1BindRequest(@NotNull String username, @NotNull String password, Control ... controls) {
        super(username, new ASN1OctetString(password), controls);
    }

    public SCRAMSHA1BindRequest(@NotNull String username, @NotNull byte[] password, Control ... controls) {
        super(username, new ASN1OctetString(password), controls);
    }

    @Override
    @NotNull
    public String getSASLMechanismName() {
        return SCRAM_SHA_1_MECHANISM_NAME;
    }

    @Override
    @NotNull
    protected String getDigestAlgorithmName() {
        return "SHA-1";
    }

    @Override
    @NotNull
    protected String getMACAlgorithmName() {
        return "HmacSHA1";
    }

    @Override
    @NotNull
    public SCRAMSHA1BindRequest getRebindRequest(@NotNull String host, int port) {
        return this.duplicate();
    }

    @Override
    @NotNull
    public SCRAMSHA1BindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public SCRAMSHA1BindRequest duplicate(@Nullable Control[] controls) {
        SCRAMSHA1BindRequest bindRequest = new SCRAMSHA1BindRequest(this.getUsername(), this.getPasswordBytes(), controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        bindRequest.setIntermediateResponseListener(this.getIntermediateResponseListener());
        bindRequest.setReferralDepth(this.getReferralDepth());
        bindRequest.setReferralConnector(this.getReferralConnectorInternal());
        return bindRequest;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SCRAMSHA1BindRequest(username='");
        buffer.append(this.getUsername());
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(@NotNull List<String> lineList, @NotNull String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(4);
        constructorArgs.add(ToCodeArgHelper.createString(this.getUsername(), "Username"));
        constructorArgs.add(ToCodeArgHelper.createString("---redacted-password---", "Password"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "SCRAMSHA1BindRequest", requestID + "Request", "new SCRAMSHA1BindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

