/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.datacache.CacheStatisticsSPI;
import org.apache.openjpa.util.OpenJPAId;

public class CacheStatisticsImpl
implements CacheStatisticsSPI {
    private static final long serialVersionUID = 9014495759588003166L;
    private static final int ARRAY_SIZE = 3;
    private long[] totalStat = new long[3];
    private long[] stat = new long[3];
    private Map<String, long[]> stats = new HashMap<String, long[]>();
    private Map<String, long[]> totalStats = new HashMap<String, long[]>();
    private Date start = new Date();
    private Date since = new Date();
    private boolean enabled = false;
    private static final int READ = 0;
    private static final int HIT = 1;
    private static final int WRITE = 2;

    @Override
    public long getReadCount() {
        return this.stat[0];
    }

    @Override
    public long getHitCount() {
        return this.stat[1];
    }

    @Override
    public long getWriteCount() {
        return this.stat[2];
    }

    @Override
    public long getTotalReadCount() {
        return this.totalStat[0];
    }

    @Override
    public long getTotalHitCount() {
        return this.totalStat[1];
    }

    @Override
    public long getTotalWriteCount() {
        return this.totalStat[2];
    }

    @Override
    public long getReadCount(Class<?> c) {
        return this.getReadCount(c.getName());
    }

    @Override
    public long getReadCount(String str) {
        return this.getCount(this.stats, str, 0);
    }

    @Override
    public long getHitCount(Class<?> c) {
        return this.getHitCount(c.getName());
    }

    @Override
    public long getHitCount(String str) {
        return this.getCount(this.stats, str, 1);
    }

    @Override
    public long getWriteCount(Class<?> c) {
        return this.getWriteCount(c.getName());
    }

    @Override
    public long getWriteCount(String str) {
        return this.getCount(this.stats, str, 2);
    }

    @Override
    public long getTotalReadCount(Class<?> c) {
        return this.getTotalReadCount(c.getName());
    }

    @Override
    public long getTotalReadCount(String str) {
        return this.getCount(this.totalStats, str, 0);
    }

    @Override
    public long getTotalHitCount(Class<?> c) {
        return this.getTotalHitCount(c.getName());
    }

    @Override
    public long getTotalHitCount(String str) {
        return this.getCount(this.totalStats, str, 1);
    }

    @Override
    public long getTotalWriteCount(Class<?> c) {
        return this.getCount(this.totalStats, c.getName(), 2);
    }

    @Override
    public long getTotalWriteCount(String str) {
        return this.getCount(this.totalStats, str, 2);
    }

    @Override
    public Date since() {
        return this.since;
    }

    @Override
    public Date start() {
        return this.start;
    }

    @Override
    public void reset() {
        this.stat = new long[3];
        this.stats.clear();
        this.since = new Date();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Set<String> classNames() {
        return this.totalStats.keySet();
    }

    @Override
    public Map<String, long[]> toMap() {
        HashMap<String, long[]> res = new HashMap<String, long[]>();
        for (Map.Entry<String, long[]> s : this.stats.entrySet()) {
            res.put(s.getKey(), s.getValue());
        }
        return res;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public void newGet(Class<?> cls, boolean hit) {
        if (!this.enabled) {
            return;
        }
        cls = cls == null ? Object.class : cls;
        String clsName = cls.getName();
        this.addSample(clsName, 0);
        if (hit) {
            this.addSample(clsName, 1);
        }
    }

    public void newGet(Object oid, boolean hit) {
        if (!this.enabled) {
            return;
        }
        if (oid instanceof OpenJPAId) {
            this.newGet(((OpenJPAId)oid).getType(), hit);
        }
    }

    @Override
    public void newPut(Class<?> cls) {
        if (!this.enabled) {
            return;
        }
        cls = cls == null ? Object.class : cls;
        this.addSample(cls.getName(), 2);
    }

    public void newPut(Object oid) {
        if (!this.enabled) {
            return;
        }
        if (oid instanceof OpenJPAId) {
            this.newPut(((OpenJPAId)oid).getType());
        }
    }

    private void addSample(String c, int index) {
        int n = index;
        this.stat[n] = this.stat[n] + 1L;
        int n2 = index;
        this.totalStat[n2] = this.totalStat[n2] + 1L;
        this.addSample(this.stats, c, index);
        this.addSample(this.totalStats, c, index);
    }

    private void addSample(Map<String, long[]> target, String c, int index) {
        long[] row = target.get(c);
        if (row == null) {
            row = new long[3];
        }
        int n = index;
        row[n] = row[n] + 1L;
        target.put(c, row);
    }

    private long getCount(Map<String, long[]> target, String c, int index) {
        long[] row = target.get(c);
        return row == null ? 0L : row[index];
    }
}

