/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.jmx;

import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.lib.jmx.CommandHandlerStatsMBean;

public abstract class AbstractCommandHandlerStats
extends StandardMBean
implements CommandHandlerStatsMBean,
Disposable {
    private final AtomicLong all = new AtomicLong(0L);
    private final AtomicLong disconnect = new AtomicLong();
    private final String name;
    private final String handlerName;
    private final MBeanServer mbeanserver;
    private final String[] commands;

    public AbstractCommandHandlerStats(Class<?> jmxClass, String jmxName, String handlerName, String[] commands) throws NotCompliantMBeanException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException {
        super(jmxClass);
        this.handlerName = handlerName;
        this.commands = commands;
        this.name = "org.apache.james:type=server,name=" + jmxName + ",chain=handlerchain,handler=commandhandler,commandhandler=" + handlerName;
        this.mbeanserver = ManagementFactory.getPlatformMBeanServer();
        ObjectName baseObjectName = new ObjectName(this.name);
        this.mbeanserver.registerMBean(this, baseObjectName);
    }

    public void increment(Response response) {
        if (response.isEndSession()) {
            this.disconnect.incrementAndGet();
        }
        this.all.incrementAndGet();
        this.incrementStats(response);
    }

    protected abstract void incrementStats(Response var1);

    @Override
    public long getAll() {
        return this.all.get();
    }

    @Override
    public String getName() {
        return this.handlerName;
    }

    public void dispose() {
        try {
            this.mbeanserver.unregisterMBean(new ObjectName(this.name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String[] getCommands() {
        return this.commands;
    }

    @Override
    public long getDisconnect() {
        return this.disconnect.get();
    }
}

