/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imapserver.netty.HAProxyMessageHandler;
import org.apache.james.protocols.api.ProxyInformation;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;
import org.apache.james.util.MDCBuilder;

public class IMAPMDCContext {
    public static MDCBuilder boundMDC(ChannelHandlerContext ctx) {
        MDCBuilder mdc = MDCBuilder.create().addToContext("protocol", "IMAP");
        IMAPMDCContext.setIpAndProxyInformation(ctx, mdc);
        if (ProtocolMDCContextFactory.ADD_HOST_TO_MDC) {
            return mdc.addToContext("host", IMAPMDCContext.retrieveHost(ctx));
        }
        return mdc;
    }

    private static void setIpAndProxyInformation(ChannelHandlerContext ctx, MDCBuilder mdcBuilder) {
        Optional.ofNullable((ProxyInformation)ctx.channel().attr(HAProxyMessageHandler.PROXY_INFO).get()).ifPresentOrElse(proxyInformation -> {
            mdcBuilder.addToContext("ip", proxyInformation.getSource().toString());
            mdcBuilder.addToContext("proxy.source", proxyInformation.getSource().toString());
            mdcBuilder.addToContext("proxy.destination", proxyInformation.getDestination().toString());
            mdcBuilder.addToContext("proxy.ip", IMAPMDCContext.retrieveIp(ctx));
        }, () -> mdcBuilder.addToContext("ip", IMAPMDCContext.retrieveIp(ctx)));
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        return remoteAddress.toString();
    }

    private static String retrieveHost(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getHostName();
        }
        return remoteAddress.toString();
    }

    public static MDCBuilder from(ImapSession imapSession) {
        return MDCBuilder.create().addToContext("user", Optional.ofNullable(imapSession.getUserName()).map(Username::asString).orElse("")).addToContextIfPresent("selectedMailbox", Optional.ofNullable(imapSession.getSelected()).map(selectedMailbox -> selectedMailbox.getMailboxId().serialize()));
    }
}

