/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.task.AsyncSafeTask;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.TaskWithId;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.ContextView;

public class SerialTaskManagerWorker
implements TaskManagerWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialTaskManagerWorker.class);
    public static final boolean MAY_INTERRUPT_IF_RUNNING = true;
    private final Scheduler taskExecutor;
    private final Scheduler asyncTaskExecutor;
    private final TaskManagerWorker.Listener listener;
    private final Map<TaskId, CompletableFuture<Task.Result>> runningTasks;
    private final Set<TaskId> cancelledTasks;
    private final Duration pollingInterval;

    public SerialTaskManagerWorker(TaskManagerWorker.Listener listener, Duration pollingInterval) {
        this.pollingInterval = pollingInterval;
        this.taskExecutor = Schedulers.fromExecutor((Executor)Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.withName((String)"task executor")));
        this.asyncTaskExecutor = Schedulers.fromExecutor((Executor)Executors.newCachedThreadPool((ThreadFactory)NamedThreadFactory.withName((String)"async task executor")));
        this.listener = listener;
        this.cancelledTasks = Sets.newConcurrentHashSet();
        this.runningTasks = Maps.newConcurrentMap();
    }

    @Override
    public Mono<Task.Result> executeTask(TaskWithId taskWithId) {
        if (!this.cancelledTasks.remove(taskWithId.getId())) {
            Mono taskMono = this.runWithMdc(taskWithId, this.listener).subscribeOn(this.schedulerForTask(taskWithId));
            CompletableFuture future = taskMono.toFuture();
            this.runningTasks.put(taskWithId.getId(), future);
            Mono pollingMono = Mono.using(() -> this.pollAdditionalInformation(taskWithId).subscribe(), ignored -> Mono.fromFuture((CompletableFuture)future).onErrorResume(exception -> Mono.from(this.handleExecutionError(taskWithId, this.listener, (Throwable)exception)).thenReturn((Object)Task.Result.PARTIAL)), Disposable::dispose).doOnTerminate(() -> this.runningTasks.remove(taskWithId.getId()));
            if (taskWithId.getTask() instanceof AsyncSafeTask) {
                pollingMono.subscribe();
                return Mono.empty();
            }
            return pollingMono;
        }
        return Mono.from(this.listener.cancelled(taskWithId.getId(), (Publisher<Optional<TaskExecutionDetails.AdditionalInformation>>)taskWithId.getTask().detailsReactive())).doOnTerminate(() -> this.runningTasks.remove(taskWithId.getId())).then(Mono.empty());
    }

    private Scheduler schedulerForTask(TaskWithId taskWithId) {
        if (taskWithId.getTask() instanceof AsyncSafeTask) {
            return this.asyncTaskExecutor;
        }
        return this.taskExecutor;
    }

    private Publisher<Void> handleExecutionError(TaskWithId taskWithId, TaskManagerWorker.Listener listener, Throwable exception) {
        if (exception instanceof CancellationException) {
            return Mono.from(listener.cancelled(taskWithId.getId(), (Publisher<Optional<TaskExecutionDetails.AdditionalInformation>>)taskWithId.getTask().detailsReactive())).then(Mono.fromCallable(() -> this.cancelledTasks.remove(taskWithId.getId()))).then();
        }
        return listener.failed(taskWithId.getId(), (Publisher<Optional<TaskExecutionDetails.AdditionalInformation>>)taskWithId.getTask().detailsReactive(), exception);
    }

    private Flux<TaskExecutionDetails.AdditionalInformation> pollAdditionalInformation(TaskWithId taskWithId) {
        return Mono.from((Publisher)taskWithId.getTask().detailsReactive()).delayElement(this.pollingInterval, Schedulers.parallel()).repeat().handle(ReactorUtils.publishIfPresent()).flatMap(information -> Mono.from(this.listener.updated(taskWithId.getId(), (Publisher<TaskExecutionDetails.AdditionalInformation>)Mono.just((Object)information))).thenReturn(information).onErrorResume(e -> {
            LOGGER.error("Error upon polling additional information updates", e);
            return Mono.empty();
        }), 16);
    }

    private Mono<Task.Result> runWithMdc(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        return this.run(taskWithId, listener).contextWrite((ContextView)ReactorUtils.context((String)"task", (MDCBuilder)MDCBuilder.create().addToContext("taskId", taskWithId.getId().asString()).addToContext("taskType", taskWithId.getTask().type().asString())));
    }

    private Mono<Task.Result> run(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        return Mono.from(listener.started(taskWithId.getId())).then(this.runTask(taskWithId, listener)).onErrorResume(this::isCausedByInterruptedException, e -> this.cancelled(taskWithId, listener)).onErrorResume(Exception.class, e -> {
            MDCStructuredLogger.forLogger((Logger)LOGGER).field("taskId", taskWithId.getId().asString()).field("taskType", taskWithId.getTask().type().asString()).log(logger -> logger.error("Error while running task {}", (Object)taskWithId.getId(), e));
            return Mono.from(listener.failed(taskWithId.getId(), (Publisher<Optional<TaskExecutionDetails.AdditionalInformation>>)taskWithId.getTask().detailsReactive(), (Throwable)e)).thenReturn((Object)Task.Result.PARTIAL);
        });
    }

    private boolean isCausedByInterruptedException(Throwable e) {
        if (e instanceof InterruptedException) {
            return true;
        }
        return Stream.iterate(e, t -> t.getCause() != null, Throwable::getCause).anyMatch(InterruptedException.class::isInstance);
    }

    private Mono<Task.Result> cancelled(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        TaskId id = taskWithId.getId();
        return Mono.from(listener.cancelled(id, (Publisher<Optional<TaskExecutionDetails.AdditionalInformation>>)taskWithId.getTask().detailsReactive())).thenReturn((Object)Task.Result.PARTIAL);
    }

    private Mono<Task.Result> runTask(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        return Mono.from((Publisher)taskWithId.getTask().runAsync()).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).doOnNext(result -> result.onComplete(new Task.CompletionOperation[]{any -> Mono.from(listener.completed(taskWithId.getId(), (Task.Result)result, (Publisher<Optional<TaskExecutionDetails.AdditionalInformation>>)taskWithId.getTask().detailsReactive())).subscribe()}).onFailure(new Task.Operation[]{() -> {
            MDCStructuredLogger.forLogger((Logger)LOGGER).field("taskId", taskWithId.getId().asString()).field("taskType", taskWithId.getTask().type().asString()).log(logger -> logger.error("Task was partially performed. Check logs for more details. Taskid : {}", (Object)taskWithId.getId()));
            Mono.from(listener.failed(taskWithId.getId(), (Publisher<Optional<TaskExecutionDetails.AdditionalInformation>>)taskWithId.getTask().detailsReactive())).subscribe();
        }}));
    }

    @Override
    public void cancelTask(TaskId taskId) {
        this.cancelledTasks.add(taskId);
        Optional.ofNullable(this.runningTasks.get(taskId)).ifPresent(task -> task.cancel(true));
    }

    @Override
    public Publisher<Void> fail(TaskId taskId, Publisher<Optional<TaskExecutionDetails.AdditionalInformation>> additionalInformationPublisher, String errorMessage, Throwable reason) {
        return this.listener.failed(taskId, additionalInformationPublisher, Optional.ofNullable(errorMessage), Optional.ofNullable(reason));
    }

    @Override
    public void close() {
        Set<TaskId> taskIds = this.runningTasks.entrySet().stream().filter(entry -> !((CompletableFuture)entry.getValue()).isCancelled() && !((CompletableFuture)entry.getValue()).isDone()).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
        if (!taskIds.isEmpty()) {
            taskIds.forEach(this::cancelTask);
            Awaitility.waitAtMost((Duration)Durations.TWO_MINUTES).pollDelay(Duration.ofMillis(500L)).until(() -> !this.cancelledTasks.containsAll(taskIds));
        }
        this.taskExecutor.dispose();
        this.asyncTaskExecutor.dispose();
    }
}

