/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.controls.ContentSyncState;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.UUID;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ContentSyncStateControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String SYNC_STATE_OID = "1.3.6.1.4.1.4203.1.9.1.2";
    private static final long serialVersionUID = 4796325788870542241L;
    @Nullable
    private final ASN1OctetString cookie;
    @NotNull
    private final ContentSyncState state;
    @NotNull
    private final UUID entryUUID;

    ContentSyncStateControl() {
        this.state = null;
        this.entryUUID = null;
        this.cookie = null;
    }

    public ContentSyncStateControl(@NotNull ContentSyncState state, @NotNull UUID entryUUID, @Nullable ASN1OctetString cookie) {
        super(SYNC_STATE_OID, false, ContentSyncStateControl.encodeValue(state, entryUUID, cookie));
        this.state = state;
        this.entryUUID = entryUUID;
        this.cookie = cookie;
    }

    public ContentSyncStateControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_STATE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            ASN1Enumerated e = ASN1Enumerated.decodeAsEnumerated(elements[0]);
            this.state = ContentSyncState.valueOf(e.intValue());
            if (this.state == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_STATE_VALUE_INVALID_STATE.get(e.intValue()));
            }
            try {
                this.entryUUID = StaticUtils.decodeUUID(elements[1].getValue());
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_STATE_VALUE_MALFORMED_UUID.get(pe.getMessage()), pe);
            }
            this.cookie = elements.length == 3 ? ASN1OctetString.decodeAsOctetString(elements[2]) : null;
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_STATE_VALUE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ContentSyncState state, @NotNull UUID entryUUID, @Nullable ASN1OctetString cookie) {
        Validator.ensureNotNull((Object)state, entryUUID);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1Enumerated(state.intValue()));
        elements.add(new ASN1OctetString(StaticUtils.encodeUUID(entryUUID)));
        if (cookie != null) {
            elements.add(cookie);
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Override
    @NotNull
    public ContentSyncStateControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new ContentSyncStateControl(oid, isCritical, value);
    }

    @Nullable
    public static ContentSyncStateControl get(@NotNull SearchResultEntry entry) throws LDAPException {
        Control c = entry.getControl(SYNC_STATE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof ContentSyncStateControl) {
            return (ContentSyncStateControl)c;
        }
        return new ContentSyncStateControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Nullable
    public static ContentSyncStateControl get(@NotNull SearchResultReference ref) throws LDAPException {
        Control c = ref.getControl(SYNC_STATE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof ContentSyncStateControl) {
            return (ContentSyncStateControl)c;
        }
        return new ContentSyncStateControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public ContentSyncState getState() {
        return this.state;
    }

    @NotNull
    public UUID getEntryUUID() {
        return this.entryUUID;
    }

    @Nullable
    public ASN1OctetString getCookie() {
        return this.cookie;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_CONTENT_SYNC_STATE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ContentSyncStateControl(state='");
        buffer.append(this.state.name());
        buffer.append("', entryUUID='");
        buffer.append(this.entryUUID);
        buffer.append('\'');
        if (this.cookie != null) {
            buffer.append(", cookie=");
            StaticUtils.toHex(this.cookie.getValue(), buffer);
        }
        buffer.append(')');
    }
}

