/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.events.EventBus;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.processor.AppendProcessor;
import org.apache.james.imap.processor.AuthenticateProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.CapabilityProcessor;
import org.apache.james.imap.processor.CheckProcessor;
import org.apache.james.imap.processor.CloseProcessor;
import org.apache.james.imap.processor.CompressProcessor;
import org.apache.james.imap.processor.CopyProcessor;
import org.apache.james.imap.processor.CreateProcessor;
import org.apache.james.imap.processor.DeleteACLProcessor;
import org.apache.james.imap.processor.DeleteProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.ExamineProcessor;
import org.apache.james.imap.processor.ExpungeProcessor;
import org.apache.james.imap.processor.GetACLProcessor;
import org.apache.james.imap.processor.GetMetadataProcessor;
import org.apache.james.imap.processor.GetQuotaProcessor;
import org.apache.james.imap.processor.GetQuotaRootProcessor;
import org.apache.james.imap.processor.IdProcessor;
import org.apache.james.imap.processor.IdleProcessor;
import org.apache.james.imap.processor.LSubProcessor;
import org.apache.james.imap.processor.ListProcessor;
import org.apache.james.imap.processor.ListRightsProcessor;
import org.apache.james.imap.processor.LoginProcessor;
import org.apache.james.imap.processor.LogoutProcessor;
import org.apache.james.imap.processor.MoveProcessor;
import org.apache.james.imap.processor.MyRightsProcessor;
import org.apache.james.imap.processor.NamespaceProcessor;
import org.apache.james.imap.processor.NoopProcessor;
import org.apache.james.imap.processor.PermitEnableCapabilityProcessor;
import org.apache.james.imap.processor.RenameProcessor;
import org.apache.james.imap.processor.ReplaceProcessor;
import org.apache.james.imap.processor.SearchProcessor;
import org.apache.james.imap.processor.SelectProcessor;
import org.apache.james.imap.processor.SetACLProcessor;
import org.apache.james.imap.processor.SetMetadataProcessor;
import org.apache.james.imap.processor.SetQuotaProcessor;
import org.apache.james.imap.processor.StartTLSProcessor;
import org.apache.james.imap.processor.StatusProcessor;
import org.apache.james.imap.processor.StoreProcessor;
import org.apache.james.imap.processor.SubscribeProcessor;
import org.apache.james.imap.processor.SystemMessageProcessor;
import org.apache.james.imap.processor.UnselectProcessor;
import org.apache.james.imap.processor.UnsubscribeProcessor;
import org.apache.james.imap.processor.XListProcessor;
import org.apache.james.imap.processor.base.AbstractProcessor;
import org.apache.james.imap.processor.base.ImapResponseMessageProcessor;
import org.apache.james.imap.processor.fetch.FetchProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;
import reactor.core.publisher.Mono;

public class DefaultProcessor
implements ImapProcessor {
    private final Map<Class, ImapProcessor> processorMap;
    private final ImapProcessor chainEndProcessor;

    public static ImapProcessor createDefaultProcessor(ImapProcessor chainEndProcessor, MailboxManager mailboxManager, EventBus eventBus, SubscriptionManager subscriptionManager, StatusResponseFactory statusResponseFactory, MailboxTyper mailboxTyper, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MetricFactory metricFactory) {
        ImmutableList.Builder builder = ImmutableList.builder();
        CapabilityProcessor capabilityProcessor = new CapabilityProcessor(mailboxManager, statusResponseFactory, metricFactory);
        builder.add((Object)new SystemMessageProcessor(mailboxManager));
        builder.add((Object)new LogoutProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)capabilityProcessor);
        builder.add((Object)new IdProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new CheckProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new LoginProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new RenameProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new DeleteProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new CreateProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new CloseProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new UnsubscribeProcessor(mailboxManager, subscriptionManager, statusResponseFactory, metricFactory));
        builder.add((Object)new SubscribeProcessor(mailboxManager, subscriptionManager, statusResponseFactory, metricFactory));
        builder.add((Object)new CopyProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new AuthenticateProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new ExpungeProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new ReplaceProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new ExamineProcessor(mailboxManager, eventBus, statusResponseFactory, metricFactory));
        builder.add((Object)new AppendProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new StoreProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new NoopProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new IdleProcessor(mailboxManager, statusResponseFactory, metricFactory));
        StatusProcessor statusProcessor = new StatusProcessor(mailboxManager, statusResponseFactory, metricFactory);
        builder.add((Object)statusProcessor);
        builder.add((Object)new LSubProcessor(mailboxManager, subscriptionManager, statusResponseFactory, metricFactory));
        builder.add((Object)new XListProcessor(mailboxManager, statusResponseFactory, mailboxTyper, metricFactory, subscriptionManager));
        builder.add(new ListProcessor(mailboxManager, statusResponseFactory, metricFactory, subscriptionManager, statusProcessor, mailboxTyper));
        builder.add((Object)new SearchProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new SelectProcessor(mailboxManager, eventBus, statusResponseFactory, metricFactory));
        builder.add((Object)new NamespaceProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new FetchProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new StartTLSProcessor(statusResponseFactory));
        builder.add((Object)new UnselectProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new CompressProcessor(statusResponseFactory));
        builder.add((Object)new GetACLProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new SetACLProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new DeleteACLProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new ListRightsProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new MyRightsProcessor(mailboxManager, statusResponseFactory, metricFactory));
        EnableProcessor enableProcessor = new EnableProcessor(mailboxManager, statusResponseFactory, metricFactory, capabilityProcessor);
        builder.add((Object)enableProcessor);
        builder.add((Object)new GetQuotaProcessor(mailboxManager, statusResponseFactory, quotaManager, quotaRootResolver, metricFactory));
        builder.add((Object)new SetQuotaProcessor(mailboxManager, statusResponseFactory, metricFactory));
        builder.add((Object)new GetQuotaRootProcessor(mailboxManager, statusResponseFactory, quotaRootResolver, quotaManager, metricFactory));
        builder.add((Object)new ImapResponseMessageProcessor());
        if (mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move)) {
            builder.add((Object)new MoveProcessor(mailboxManager, statusResponseFactory, metricFactory));
        }
        if (mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Annotation)) {
            builder.add((Object)new SetMetadataProcessor(mailboxManager, statusResponseFactory, metricFactory));
            builder.add((Object)new GetMetadataProcessor(mailboxManager, statusResponseFactory, metricFactory));
        }
        ImmutableList processors = builder.build();
        processors.stream().filter(CapabilityImplementingProcessor.class::isInstance).map(CapabilityImplementingProcessor.class::cast).forEach(capabilityProcessor::addProcessor);
        processors.stream().filter(PermitEnableCapabilityProcessor.class::isInstance).map(PermitEnableCapabilityProcessor.class::cast).forEach(enableProcessor::addProcessor);
        ImmutableMap processorMap = (ImmutableMap)processors.stream().map(AbstractProcessor.class::cast).flatMap(DefaultProcessor::asPairStream).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight));
        return new DefaultProcessor((Map<Class, ImapProcessor>)processorMap, chainEndProcessor);
    }

    private static Stream<Pair<Class, AbstractProcessor>> asPairStream(AbstractProcessor p) {
        return p.acceptableClasses().stream().map(clazz -> Pair.of((Object)clazz, (Object)p));
    }

    public DefaultProcessor(Map<Class, ImapProcessor> processorMap, ImapProcessor chainEndProcessor) {
        this.processorMap = processorMap;
        this.chainEndProcessor = chainEndProcessor;
    }

    @Override
    public void process(ImapMessage message, ImapProcessor.Responder responder, ImapSession session) {
        this.processorMap.getOrDefault(message.getClass(), this.chainEndProcessor).process(message, responder, session);
    }

    @Override
    public Mono<Void> processReactive(ImapMessage message, ImapProcessor.Responder responder, ImapSession session) {
        return this.processorMap.getOrDefault(message.getClass(), this.chainEndProcessor).processReactive(message, responder, session);
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        this.processorMap.values().forEach(processor -> processor.configure(imapConfiguration));
    }
}

