/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.event;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.Named;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusId;
import org.apache.james.events.EventBusReconnectionHandler;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.KeyReconnectionHandler;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.RabbitEventBusConsumerHealthCheck;
import org.apache.james.events.RabbitMQEventBus;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.events.RoutingKeyConverter;
import org.apache.james.jmap.change.Factory;
import org.apache.james.jmap.change.JmapEventSerializer;
import org.apache.james.jmap.pushsubscription.PushListener;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import reactor.rabbitmq.Sender;

public class JMAPEventBusModule
extends AbstractModule {
    protected void configure() {
        this.bind(EventBusId.class).annotatedWith((Annotation)Names.named((String)"JMAP")).toInstance((Object)EventBusId.random());
    }

    @ProvidesIntoSet
    InitializationOperation workQueue(@Named(value="JMAP") RabbitMQEventBus instance, PushListener pushListener) {
        return InitilizationOperationBuilder.forClass(RabbitMQEventBus.class).init(() -> {
            instance.start();
            instance.register((EventListener.ReactiveGroupEventListener)pushListener);
        });
    }

    @ProvidesIntoSet
    SimpleConnectionPool.ReconnectionHandler provideReconnectionHandler(@Named(value="JMAP") RabbitMQEventBus eventBus) {
        return new EventBusReconnectionHandler(eventBus);
    }

    @ProvidesIntoSet
    SimpleConnectionPool.ReconnectionHandler provideReconnectionHandler(@Named(value="JMAP") EventBusId eventBusId, RabbitMQConfiguration configuration) {
        return new KeyReconnectionHandler(NamingStrategy.JMAP_NAMING_STRATEGY, eventBusId, configuration);
    }

    @ProvidesIntoSet
    HealthCheck healthCheck(@Named(value="JMAP") RabbitMQEventBus eventBus, SimpleConnectionPool connectionPool) {
        return new RabbitEventBusConsumerHealthCheck(eventBus, NamingStrategy.JMAP_NAMING_STRATEGY, connectionPool);
    }

    @Provides
    @Singleton
    @Named(value="JMAP")
    RabbitMQEventBus provideJmapEventBus(Sender sender, ReceiverProvider receiverProvider, JmapEventSerializer eventSerializer, RetryBackoffConfiguration retryBackoffConfiguration, EventDeadLetters eventDeadLetters, MetricFactory metricFactory, ReactorRabbitMQChannelPool channelPool, @Named(value="JMAP") EventBusId eventBusId, RabbitMQConfiguration configuration) {
        return new RabbitMQEventBus(NamingStrategy.JMAP_NAMING_STRATEGY, sender, receiverProvider, (EventSerializer)eventSerializer, retryBackoffConfiguration, new RoutingKeyConverter((Set)ImmutableSet.of((Object)new Factory())), eventDeadLetters, metricFactory, channelPool, eventBusId, configuration);
    }

    @Provides
    @Singleton
    @Named(value="JMAP")
    EventBus provideJmapEventBus(@Named(value="JMAP") RabbitMQEventBus rabbitMQEventBus) {
        return rabbitMQEventBus;
    }

    @ProvidesIntoSet
    EventBus registerEventBus(@Named(value="JMAP") EventBus eventBus) {
        return eventBus;
    }
}

