/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.MyRightsRequest;
import org.apache.james.imap.message.response.MyRightsResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MyRightsProcessor
extends AbstractMailboxProcessor<MyRightsRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyRightsProcessor.class);
    private static final List<Capability> CAPABILITIES = Collections.singletonList(ImapConstants.SUPPORTS_ACL);

    @Inject
    public MyRightsProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(MyRightsRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(MyRightsRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        String mailboxName = request.getMailboxName();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
        return Mono.from((Publisher)mailboxManager.getMailboxReactive(mailboxPath, mailboxSession)).doOnNext((Consumer)Throwing.consumer(mailbox -> {
            MailboxACL.Rfc4314Rights myRights = mailboxManager.myRights(mailbox.getMailboxEntity(), mailboxSession);
            if (!(myRights.contains(MailboxACL.Right.Lookup) || myRights.contains(MailboxACL.Right.Read) || myRights.contains(MailboxACL.Right.Insert) || myRights.contains(MailboxACL.Right.CreateMailbox) || myRights.contains(MailboxACL.Right.DeleteMailbox) || myRights.contains(MailboxACL.Right.Administer))) {
                this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            } else {
                MyRightsResponse myRightsResponse = new MyRightsResponse(mailboxName, myRights);
                responder.respond(myRightsResponse);
                this.okComplete(request, responder);
            }
        })).then().onErrorResume(MailboxNotFoundException.class, e -> {
            this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            return Mono.empty();
        }).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
            return ReactorUtils.logAsMono(() -> LOGGER.error("{} failed for mailbox {}", new Object[]{request.getCommand().getName(), mailboxName, e}));
        });
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected MDCBuilder mdc(MyRightsRequest request) {
        return MDCBuilder.create().addToContext("action", "MYRIGHTS").addToContext("mailbox", request.getMailboxName());
    }
}

