/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.ThreadPoolResponse;
import org.opensearch.client.opensearch.cat.thread_pool.ThreadPoolSize;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class ThreadPoolRequest
extends CatRequestBase {
    @Nullable
    private final ThreadPoolSize size;
    private final List<String> threadPoolPatterns;
    public static final Endpoint<ThreadPoolRequest, ThreadPoolResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ThreadPoolRequest, ThreadPoolResponse>(request -> "GET", request -> {
        boolean _threadPoolPatterns = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.threadPoolPatterns())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/thread_pool");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/thread_pool");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.threadPoolPatterns.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.size != null) {
            params.put("size", request.size.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ThreadPoolResponse._DESERIALIZER);

    private ThreadPoolRequest(Builder builder) {
        this.size = builder.size;
        this.threadPoolPatterns = ApiTypeHelper.unmodifiable(builder.threadPoolPatterns);
    }

    public static ThreadPoolRequest of(Function<Builder, ObjectBuilder<ThreadPoolRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ThreadPoolSize size() {
        return this.size;
    }

    public final List<String> threadPoolPatterns() {
        return this.threadPoolPatterns;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ThreadPoolRequest> {
        @Nullable
        private ThreadPoolSize size;
        @Nullable
        private List<String> threadPoolPatterns;

        public final Builder size(@Nullable ThreadPoolSize value) {
            this.size = value;
            return this;
        }

        public final Builder threadPoolPatterns(List<String> list) {
            this.threadPoolPatterns = Builder._listAddAll(this.threadPoolPatterns, list);
            return this;
        }

        public final Builder threadPoolPatterns(String value, String ... values) {
            this.threadPoolPatterns = Builder._listAdd(this.threadPoolPatterns, value, values);
            return this;
        }

        @Override
        public ThreadPoolRequest build() {
            this._checkSingleUse();
            return new ThreadPoolRequest(this);
        }
    }
}

