/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.metrics.api.GaugeRegistry;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ReactiveThrottler {
    private final int maxConcurrentRequests;
    private final int maxQueueSize;
    private final AtomicInteger concurrentRequests = new AtomicInteger(0);
    private final Queue<Publisher<Void>> queue = new ConcurrentLinkedQueue<Publisher<Void>>();

    public ReactiveThrottler(GaugeRegistry gaugeRegistry, int maxConcurrentRequests, int maxQueueSize) {
        gaugeRegistry.register("imap.request.queue.size", () -> Math.max(this.concurrentRequests.get() - maxConcurrentRequests, 0));
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.maxQueueSize = maxQueueSize;
    }

    public Mono<Void> throttle(Publisher<Void> task, ImapMessage imapMessage) {
        if (this.maxConcurrentRequests < 0) {
            return Mono.from(task);
        }
        int requestNumber = this.concurrentRequests.incrementAndGet();
        if (requestNumber <= this.maxConcurrentRequests) {
            return Mono.from(task).doFinally(any -> this.onRequestDone());
        }
        if (requestNumber <= this.maxQueueSize + this.maxConcurrentRequests) {
            Sinks.One one = Sinks.one();
            this.queue.add((Publisher<Void>)Mono.from(task).then(Mono.fromRunnable(() -> one.emitEmpty(Sinks.EmitFailureHandler.FAIL_FAST))));
            return one.asMono();
        }
        this.concurrentRequests.decrementAndGet();
        return Mono.error((Throwable)new RejectedException(String.format("The IMAP server has reached its maximum capacity (concurrent requests: %d, queue size: %d)", this.maxConcurrentRequests, this.maxQueueSize), imapMessage));
    }

    private void onRequestDone() {
        this.concurrentRequests.decrementAndGet();
        Publisher<Void> throttled = this.queue.poll();
        if (throttled != null) {
            Mono.from(throttled).doFinally(any -> this.onRequestDone()).subscribe();
        }
    }

    public static class RejectedException
    extends RuntimeException {
        private final ImapMessage imapMessage;

        public RejectedException(String message, ImapMessage imapMessage) {
            super(message);
            this.imapMessage = imapMessage;
        }

        public ImapMessage getImapMessage() {
            return this.imapMessage;
        }
    }
}

