/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.opensearch.client.RestClient;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.cluster.HealthRequest;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.ClearScrollRequest;
import org.opensearch.client.opensearch.core.ClearScrollResponse;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.InfoResponse;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.CreateIndexResponse;
import org.opensearch.client.opensearch.indices.ExistsAliasRequest;
import org.opensearch.client.opensearch.indices.ExistsRequest;
import org.opensearch.client.opensearch.indices.UpdateAliasesRequest;
import org.opensearch.client.opensearch.indices.UpdateAliasesResponse;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ReactorOpenSearchClient
implements AutoCloseable {
    private final OpenSearchAsyncClient client;
    private final RestClient lowLevelRestClient;

    public ReactorOpenSearchClient(OpenSearchAsyncClient client, RestClient lowLevelRestClient) {
        this.client = client;
        this.lowLevelRestClient = lowLevelRestClient;
    }

    public Mono<BulkResponse> bulk(BulkRequest bulkRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.bulk(bulkRequest));
    }

    public Mono<ClearScrollResponse> clearScroll(ClearScrollRequest clearScrollRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.clearScroll(clearScrollRequest));
    }

    public Mono<DeleteResponse> delete(DeleteRequest deleteRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.delete(deleteRequest));
    }

    public Mono<DeleteByQueryResponse> deleteByQuery(DeleteByQueryRequest deleteRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.deleteByQuery(deleteRequest));
    }

    public RestClient getLowLevelClient() {
        return this.lowLevelRestClient;
    }

    public <T> Mono<IndexResponse> index(IndexRequest<T> indexRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.index(indexRequest));
    }

    public Mono<BooleanResponse> indexExists(ExistsRequest existsRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.indices().exists(existsRequest));
    }

    public Mono<BooleanResponse> aliasExists(ExistsAliasRequest existsAliasRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.indices().existsAlias(existsAliasRequest));
    }

    public Mono<CreateIndexResponse> createIndex(CreateIndexRequest indexRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.indices().create(indexRequest));
    }

    public Mono<UpdateAliasesResponse> updateAliases(UpdateAliasesRequest updateAliasesRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.indices().updateAliases(updateAliasesRequest));
    }

    public Mono<InfoResponse> info() throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.info());
    }

    public Mono<ScrollResponse<ObjectNode>> scroll(ScrollRequest scrollRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.scroll(scrollRequest, ObjectNode.class));
    }

    public Mono<SearchResponse<ObjectNode>> search(SearchRequest searchRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.search(searchRequest, ObjectNode.class));
    }

    public Mono<HealthResponse> health(HealthRequest request) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.cluster().health(request));
    }

    public Mono<GetResponse<ObjectNode>> get(GetRequest getRequest) throws IOException {
        return ReactorOpenSearchClient.toReactor(this.client.get(getRequest, ObjectNode.class));
    }

    @Override
    public void close() throws IOException {
        this.lowLevelRestClient.close();
    }

    private static <T> Mono<T> toReactor(CompletableFuture<T> async) {
        return Mono.fromFuture(async).publishOn(Schedulers.boundedElastic());
    }
}

