/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;

public class OidcSASLConfiguration {
    private final URL jwksURL;
    private final String claim;
    private final URL oidcConfigurationURL;
    private final String scope;

    public static OidcSASLConfiguration parse(HierarchicalConfiguration<ImmutableNode> configuration) throws MalformedURLException {
        String jwksURL = configuration.getString("jwksURL", null);
        String claim = configuration.getString("claim", null);
        String oidcConfigurationURL = configuration.getString("oidcConfigurationURL", null);
        String scope = configuration.getString("scope", null);
        Preconditions.checkNotNull((Object)jwksURL, (Object)"`jwksURL` property need to be specified inside the oidc tag");
        Preconditions.checkNotNull((Object)claim, (Object)"`claim` property need to be specified inside the oidc tag");
        Preconditions.checkNotNull((Object)oidcConfigurationURL, (Object)"`oidcConfigurationURL` property need to be specified inside the oidc tag");
        Preconditions.checkNotNull((Object)scope, (Object)"`scope` property need to be specified inside the oidc tag");
        return new OidcSASLConfiguration(jwksURL, claim, oidcConfigurationURL, scope);
    }

    public OidcSASLConfiguration(URL jwksURL, String claim, URL oidcConfigurationURL, String scope) {
        this.jwksURL = jwksURL;
        this.claim = claim;
        this.oidcConfigurationURL = oidcConfigurationURL;
        this.scope = scope;
    }

    public OidcSASLConfiguration(String jwksURL, String claim, String oidcConfigurationURL, String scope) throws MalformedURLException {
        this(new URL(jwksURL), claim, new URL(oidcConfigurationURL), scope);
    }

    public URL getJwksURL() {
        return this.jwksURL;
    }

    public String getClaim() {
        return this.claim;
    }

    public URL getOidcConfigurationURL() {
        return this.oidcConfigurationURL;
    }

    public String getScope() {
        return this.scope;
    }
}

