/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class ConnectionCountHandler
extends SimpleChannelUpstreamHandler {
    public final AtomicInteger currentConnectionCount = new AtomicInteger();
    public final AtomicLong connectionsTillStartup = new AtomicLong();

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.currentConnectionCount.decrementAndGet();
        super.channelClosed(ctx, e);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.currentConnectionCount.incrementAndGet();
        this.connectionsTillStartup.incrementAndGet();
        super.channelOpen(ctx, e);
    }

    public int getCurrentConnectionCount() {
        return this.currentConnectionCount.get();
    }

    public long getConnectionsTillStartup() {
        return this.connectionsTillStartup.get();
    }
}

