/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.webadmin.dto.OccupationDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;

public class QuotaDetailsDTO {
    private final Optional<ValidatedQuotaDTO> global;
    private final Optional<ValidatedQuotaDTO> domain;
    private final Optional<ValidatedQuotaDTO> user;
    private final Optional<ValidatedQuotaDTO> computed;
    private final OccupationDTO occupation;

    public static Builder builder() {
        return new Builder();
    }

    private QuotaDetailsDTO(Optional<ValidatedQuotaDTO> global, Optional<ValidatedQuotaDTO> domain, Optional<ValidatedQuotaDTO> user, Optional<ValidatedQuotaDTO> computed, OccupationDTO occupation) {
        this.global = global;
        this.domain = domain;
        this.user = user;
        this.computed = computed;
        this.occupation = occupation;
    }

    public Optional<ValidatedQuotaDTO> getGlobal() {
        return this.global;
    }

    public Optional<ValidatedQuotaDTO> getDomain() {
        return this.domain;
    }

    public Optional<ValidatedQuotaDTO> getUser() {
        return this.user;
    }

    public Optional<ValidatedQuotaDTO> getComputed() {
        return this.computed;
    }

    public OccupationDTO getOccupation() {
        return this.occupation;
    }

    public static class Builder {
        private Optional<ValidatedQuotaDTO> global = Optional.empty();
        private Optional<ValidatedQuotaDTO> domain;
        private Optional<ValidatedQuotaDTO> user = Optional.empty();
        private Optional<ValidatedQuotaDTO> computed = Optional.empty();
        private OccupationDTO occupation;

        private Builder() {
        }

        public Builder global(ValidatedQuotaDTO global) {
            this.global = Optional.of(global);
            return this;
        }

        public Builder domain(ValidatedQuotaDTO domain) {
            this.domain = Optional.of(domain);
            return this;
        }

        public Builder user(ValidatedQuotaDTO user) {
            this.user = Optional.of(user);
            return this;
        }

        public Builder computed(ValidatedQuotaDTO computed) {
            this.computed = Optional.of(computed);
            return this;
        }

        public Builder occupation(Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota, Quota<QuotaCountLimit, QuotaCountUsage> countQuota) {
            this.occupation = OccupationDTO.from(sizeQuota, countQuota);
            return this;
        }

        public Builder valueForScope(Quota.Scope scope, ValidatedQuotaDTO value) {
            switch (scope) {
                case Global: {
                    return this.global(value);
                }
                case Domain: {
                    return this.domain(value);
                }
                case User: {
                    return this.user(value);
                }
            }
            return this;
        }

        public QuotaDetailsDTO build() {
            Preconditions.checkNotNull((Object)this.occupation);
            return new QuotaDetailsDTO(this.global, this.domain, this.user, this.computed, this.occupation);
        }
    }
}

