/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.api;

import com.github.fge.lambdas.Throwing;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.util.FunctionalUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EmptyErrorMailRepositoryHealthCheck
implements HealthCheck {
    public static final ComponentName COMPONENT_NAME = new ComponentName("EmptyErrorMailRepository");
    private final MailRepositoryStore repositoryStore;
    private final MailRepositoryPath errorRepositoryPath;

    public EmptyErrorMailRepositoryHealthCheck(MailRepositoryPath errorRepositoryPath, MailRepositoryStore repositoryStore) {
        this.repositoryStore = repositoryStore;
        this.errorRepositoryPath = errorRepositoryPath;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return Flux.fromStream((Supplier)Throwing.supplier(() -> this.repositoryStore.getByPath(this.errorRepositoryPath))).any((Predicate)Throwing.predicate(repository -> repository.size() > 0L)).filter(FunctionalUtils.identityPredicate()).map(hasSize -> Result.degraded((ComponentName)COMPONENT_NAME, (String)"MailRepository is not empty")).switchIfEmpty(Mono.just((Object)Result.healthy((ComponentName)COMPONENT_NAME)));
    }
}

