/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.base.Joiner;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.FileNotFoundException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.modules.data.JPAConfiguration;
import org.apache.james.utils.PropertiesProvider;

public class JPAEntityManagerModule
extends AbstractModule {
    @Provides
    @Singleton
    public EntityManagerFactory provideEntityManagerFactory(JPAConfiguration jpaConfiguration) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("openjpa.ConnectionDriverName", jpaConfiguration.getDriverName());
        properties.put("openjpa.ConnectionURL", jpaConfiguration.getDriverURL());
        jpaConfiguration.getCredential().ifPresent(credential -> {
            properties.put("openjpa.ConnectionUserName", credential.getUsername());
            properties.put("openjpa.ConnectionPassword", credential.getPassword());
        });
        ArrayList<CallSite> connectionFactoryProperties = new ArrayList<CallSite>();
        connectionFactoryProperties.add((CallSite)((Object)("TestOnBorrow=" + jpaConfiguration.isTestOnBorrow())));
        jpaConfiguration.getValidationQueryTimeoutSec().ifPresent(timeoutSecond -> connectionFactoryProperties.add((CallSite)((Object)("ValidationTimeout=" + timeoutSecond * 1000))));
        jpaConfiguration.getValidationQuery().ifPresent(validationQuery -> connectionFactoryProperties.add((CallSite)((Object)("ValidationSQL='" + validationQuery + "'"))));
        properties.put("openjpa.ConnectionFactoryProperties", Joiner.on((String)", ").join(connectionFactoryProperties));
        return Persistence.createEntityManagerFactory((String)"Global", properties);
    }

    @Provides
    @Singleton
    JPAConfiguration provideConfiguration(PropertiesProvider propertiesProvider) throws FileNotFoundException, ConfigurationException {
        Configuration dataSource = propertiesProvider.getConfiguration("james-database");
        return JPAConfiguration.builder().driverName(dataSource.getString("database.driverClassName")).driverURL(dataSource.getString("database.url")).testOnBorrow(dataSource.getBoolean("datasource.testOnBorrow", false)).validationQueryTimeoutSec(dataSource.getInteger("datasource.validationQueryTimeoutSec", null)).validationQuery(dataSource.getString("datasource.validationQuery", null)).username(dataSource.getString("database.username")).password(dataSource.getString("database.password")).build();
    }
}

