/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.library.netmatcher;

import com.google.common.base.Splitter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.inetnetwork.InetNetworkBuilder;
import org.apache.james.dnsservice.library.inetnetwork.model.InetNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetMatcher.class);
    public static final String NETS_SEPARATOR = ",";
    private final DNSService dnsServer;
    private SortedSet<InetNetwork> networks;

    public NetMatcher(String[] nets, DNSService dnsServer) {
        this.dnsServer = dnsServer;
        this.initInetNetworks(nets);
    }

    public NetMatcher(Collection<String> nets, DNSService dnsServer) {
        this.dnsServer = dnsServer;
        this.initInetNetworks(nets);
    }

    public NetMatcher(String commaSeparatedNets, DNSService dnsServer) {
        this.dnsServer = dnsServer;
        List nets = Splitter.on((String)NETS_SEPARATOR).trimResults().splitToList((CharSequence)commaSeparatedNets);
        this.initInetNetworks(nets);
    }

    public boolean matchInetNetwork(String hostIP) {
        InetAddress ip;
        try {
            ip = this.dnsServer.getByName(hostIP);
        }
        catch (UnknownHostException uhe) {
            LOGGER.info("Cannot resolve address for {}: {}", (Object)hostIP, (Object)uhe.getMessage());
            return false;
        }
        return this.matchInetNetwork(ip);
    }

    public boolean matchInetNetwork(InetAddress ip) {
        boolean sameNet = false;
        Iterator iter = this.networks.iterator();
        while (!sameNet && iter.hasNext()) {
            InetNetwork network = (InetNetwork)iter.next();
            sameNet = network.contains(ip);
        }
        return sameNet;
    }

    public String toString() {
        return this.networks.toString();
    }

    private void initInetNetworks(Collection<String> nets) {
        this.initInetNetworks((String[])nets.toArray(String[]::new));
    }

    private void initInetNetworks(String[] nets) {
        this.networks = new TreeSet<InetNetwork>(Comparator.comparing(Object::toString));
        InetNetworkBuilder inetNetwork = new InetNetworkBuilder(this.dnsServer);
        for (String net : nets) {
            try {
                InetNetwork inet = inetNetwork.getFromString(net);
                this.networks.add(inet);
            }
            catch (UnknownHostException uhe) {
                LOGGER.info("Cannot resolve address: {}", (Object)uhe.getMessage());
            }
        }
    }
}

